/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Explanation;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneCompositeProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeBiFunctionProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeFunctionProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeListProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeTriFunctionProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDocumentProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDocumentReferenceProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneEntityProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneEntityReferenceProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneExplanationProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneIdProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneScoreProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.engine.search.common.spi.SearchIndexIdentifierContext;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.DocumentReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.EntityProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.EntityReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.IdProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ScoreProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.util.common.function.TriFunction;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public class LuceneSearchProjectionBuilderFactory
implements SearchProjectionBuilderFactory {
    private final LuceneSearchIndexScope<?> scope;

    public LuceneSearchProjectionBuilderFactory(LuceneSearchIndexScope<?> scope) {
        this.scope = scope;
    }

    public DocumentReferenceProjectionBuilder documentReference() {
        return new LuceneDocumentReferenceProjection.Builder(this.scope);
    }

    public <E> EntityProjectionBuilder<E> entity() {
        return new LuceneEntityProjection.Builder(this.scope);
    }

    public <R> EntityReferenceProjectionBuilder<R> entityReference() {
        return new LuceneEntityReferenceProjection.Builder(this.scope);
    }

    public <I> IdProjectionBuilder<I> id(Class<I> identifierType) {
        SearchIndexIdentifierContext identifier = this.scope.identifier();
        return new LuceneIdProjection.Builder(this.scope, identifier.projectionConverter().withConvertedType(identifierType, (EventContextProvider)identifier));
    }

    public ScoreProjectionBuilder score() {
        return new LuceneScoreProjection.Builder(this.scope);
    }

    public <P> CompositeProjectionBuilder<P> composite(Function<List<?>, P> transformer, SearchProjection<?> ... projections) {
        ArrayList typedProjections = new ArrayList(projections.length);
        for (SearchProjection<?> projection : projections) {
            typedProjections.add(this.toImplementation(projection));
        }
        return new AbstractLuceneCompositeProjection.Builder<P>(new LuceneCompositeListProjection<P>(this.scope, transformer, typedProjections));
    }

    public <P1, P> CompositeProjectionBuilder<P> composite(Function<P1, P> transformer, SearchProjection<P1> projection) {
        return new AbstractLuceneCompositeProjection.Builder(new LuceneCompositeFunctionProjection<P1, P>(this.scope, transformer, this.toImplementation(projection)));
    }

    public <P1, P2, P> CompositeProjectionBuilder<P> composite(BiFunction<P1, P2, P> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2) {
        return new AbstractLuceneCompositeProjection.Builder(new LuceneCompositeBiFunctionProjection<P1, P2, P>(this.scope, transformer, this.toImplementation(projection1), this.toImplementation(projection2)));
    }

    public <P1, P2, P3, P> CompositeProjectionBuilder<P> composite(TriFunction<P1, P2, P3, P> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2, SearchProjection<P3> projection3) {
        return new AbstractLuceneCompositeProjection.Builder(new LuceneCompositeTriFunctionProjection<P1, P2, P3, P>(this.scope, transformer, this.toImplementation(projection1), this.toImplementation(projection2), this.toImplementation(projection3)));
    }

    public SearchProjectionBuilder<Document> document() {
        return new LuceneDocumentProjection.Builder(this.scope);
    }

    public SearchProjectionBuilder<Explanation> explanation() {
        return new LuceneExplanationProjection.Builder(this.scope);
    }

    private <T> LuceneSearchProjection<?, T> toImplementation(SearchProjection<T> projection) {
        return LuceneSearchProjection.from(this.scope, projection);
    }
}

