/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.BitSet;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorRootContext;
import org.hibernate.search.mapper.pojo.route.DocumentRouteDescriptor;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.impl.PojoDocumentReferenceProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexingPlanDelegate;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

final class PojoTypeIndexingPlanIndexDelegate<I, E>
implements PojoTypeIndexingPlanDelegate<I, E> {
    private final PojoWorkIndexedTypeContext<I, E> typeContext;
    private final PojoWorkSessionContext sessionContext;
    private final PojoIndexingProcessorRootContext processorContext;
    private final IndexIndexingPlan indexPlan;

    PojoTypeIndexingPlanIndexDelegate(PojoWorkIndexedTypeContext<I, E> typeContext, PojoWorkSessionContext sessionContext, PojoIndexingProcessorRootContext processorContext, IndexIndexingPlan indexPlan) {
        this.typeContext = typeContext;
        this.sessionContext = sessionContext;
        this.processorContext = processorContext;
        this.indexPlan = indexPlan;
    }

    @Override
    public boolean isDirtyForAddOrUpdate(boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPathsOrNull) {
        return forceSelfDirty || dirtyPathsOrNull != null && this.typeContext.dirtySelfFilter().test(dirtyPathsOrNull);
    }

    @Override
    public void add(I identifier, DocumentRouteDescriptor route, Supplier<E> entitySupplier) {
        String documentIdentifier = this.typeContext.toDocumentIdentifier(this.sessionContext, identifier);
        PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, route.routingKey(), identifier);
        this.indexPlan.add((DocumentReferenceProvider)referenceProvider, this.typeContext.toDocumentContributor(this.sessionContext, this.processorContext, identifier, entitySupplier));
    }

    @Override
    public void addOrUpdate(I identifier, DocumentRoutesDescriptor routes, Supplier<E> entitySupplier, boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPaths, boolean updatedBecauseOfContained, boolean updateBecauseOfDirty) {
        String documentIdentifier = this.typeContext.toDocumentIdentifier(this.sessionContext, identifier);
        this.delegateDeletePrevious(identifier, documentIdentifier, routes.previousRoutes());
        if (routes.currentRoute() == null) {
            return;
        }
        PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, routes.currentRoute().routingKey(), identifier);
        this.indexPlan.addOrUpdate((DocumentReferenceProvider)referenceProvider, this.typeContext.toDocumentContributor(this.sessionContext, this.processorContext, identifier, entitySupplier));
    }

    @Override
    public void delete(I identifier, DocumentRoutesDescriptor routes, Supplier<E> entitySupplier) {
        String documentIdentifier = this.typeContext.toDocumentIdentifier(this.sessionContext, identifier);
        this.delegateDeletePrevious(identifier, documentIdentifier, routes.previousRoutes());
        if (routes.currentRoute() == null) {
            return;
        }
        PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, routes.currentRoute().routingKey(), identifier);
        this.indexPlan.delete((DocumentReferenceProvider)referenceProvider);
    }

    @Override
    public void discard() {
        this.indexPlan.discard();
    }

    @Override
    public <R> CompletableFuture<MultiEntityOperationExecutionReport<R>> executeAndReport(EntityReferenceFactory<R> entityReferenceFactory) {
        return this.indexPlan.executeAndReport(entityReferenceFactory);
    }

    private void delegateDeletePrevious(I identifier, String documentIdentifier, Collection<DocumentRouteDescriptor> previousRoutes) {
        for (DocumentRouteDescriptor route : previousRoutes) {
            PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, route.routingKey(), identifier);
            this.indexPlan.delete((DocumentReferenceProvider)referenceProvider);
        }
    }
}

