/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.core.server.management.NotificationService;

public class SimpleNotificationService
implements NotificationService {
    private final List<NotificationListener> listeners = new ArrayList<NotificationListener>();

    public void addNotificationListener(NotificationListener listener) {
        this.listeners.add(listener);
    }

    public void enableNotifications(boolean enable) {
    }

    public void removeNotificationListener(NotificationListener listener) {
        this.listeners.remove(listener);
    }

    public void sendNotification(Notification notification) throws Exception {
        for (NotificationListener listener : this.listeners) {
            listener.onNotification(notification);
        }
    }

    public static class Listener
    implements NotificationListener {
        private final List<Notification> notifications = new ArrayList<Notification>();

        public void onNotification(Notification notification) {
            this.notifications.add(notification);
        }

        public List<Notification> getNotifications() {
            return this.notifications;
        }
    }
}

