/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Test;

public class AmqpDLQReceiverTest
extends AmqpClientTestSupport {
    @Test(timeout=60000L)
    public void testCreateDurableReceiver() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        this.sendMessages(this.getQueueName(), 1);
        Queue queue = this.getProxyToQueue(this.getQueueName());
        AmqpDLQReceiverTest.assertNotNull((Object)queue);
        receiver.flow(100);
        for (int i = 0; i < 10; ++i) {
            this.instanceLog.debug((Object)("i = " + i));
            AmqpMessage receive = receiver.receive(5000L, TimeUnit.MILLISECONDS);
            receive.modified(Boolean.valueOf(true), Boolean.valueOf(false));
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            this.instanceLog.debug((Object)("receive = " + receive.getWrappedMessage().getDeliveryCount()));
            this.instanceLog.debug((Object)("queueView.getMessageCount() = " + queueView.getMessageCount()));
            this.instanceLog.debug((Object)("queueView.getDeliveringCount() = " + queueView.getDeliveringCount()));
            this.instanceLog.debug((Object)("queueView.getPersistentSize() = " + queueView.getPersistentSize()));
        }
        receiver.close();
        connection.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        this.instanceLog.debug((Object)("queueView.getMessageCount() = " + queueView.getMessageCount()));
        this.instanceLog.debug((Object)("queueView.getDeliveringCount() = " + queueView.getDeliveringCount()));
        this.instanceLog.debug((Object)("queueView.getPersistentSize() = " + queueView.getPersistentSize()));
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
    }
}

