/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.HashSet;
import java.util.Random;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Test;

public class JMSTransactionTest
extends JMSClientTestSupport {
    @Test(timeout=60000L)
    public void testProduceMessageAndCommit() throws Throwable {
        Connection connection = this.createConnection();
        Session session = connection.createSession(true, 0);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.instanceLog.debug((Object)("queue:" + queue.getQueueName()));
        MessageProducer p = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            TextMessage message = session.createTextMessage();
            message.setText("Message:" + i);
            p.send((Message)message);
        }
        session.commit();
        session.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
    }

    @Test(timeout=60000L)
    public void testProduceMessageAndRollback() throws Throwable {
        Connection connection = this.createConnection();
        Session session = connection.createSession(true, 0);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.instanceLog.debug((Object)("queue:" + queue.getQueueName()));
        MessageProducer p = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            TextMessage message = session.createTextMessage();
            message.setText("Message:" + i);
            p.send((Message)message);
        }
        session.rollback();
        session.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
    }

    @Test(timeout=60000L)
    public void testProducedMessageAreRolledBackOnSessionClose() throws Exception {
        int numMessages = 10;
        Connection connection = this.createConnection();
        Session session = connection.createSession(true, 0);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        MessageProducer p = session.createProducer((Destination)queue);
        byte[] bytes = new byte[2048];
        new Random().nextBytes(bytes);
        for (int i = 0; i < numMessages; ++i) {
            TextMessage message = session.createTextMessage();
            message.setText("msg:" + i);
            p.send((Message)message);
        }
        session.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
    }

    @Test(timeout=60000L)
    public void testConsumeMessagesAndCommit() throws Throwable {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.instanceLog.debug((Object)("queue:" + queue.getQueueName()));
        MessageProducer p = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            TextMessage message = session.createTextMessage();
            message.setText("Message:" + i);
            p.send((Message)message);
        }
        session.close();
        session = connection.createSession(true, 0);
        MessageConsumer cons = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 10; ++i) {
            TextMessage message = (TextMessage)cons.receive(5000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)("Message:" + i), (Object)message.getText());
        }
        session.commit();
        session.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
    }

    @Test(timeout=60000L)
    public void testConsumeMessagesAndRollback() throws Throwable {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        MessageProducer p = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            TextMessage message = session.createTextMessage();
            message.setText("Message:" + i);
            p.send((Message)message);
        }
        session.close();
        session = connection.createSession(true, 0);
        MessageConsumer cons = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 10; ++i) {
            TextMessage message = (TextMessage)cons.receive(5000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)("Message:" + i), (Object)message.getText());
        }
        session.rollback();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
    }

    @Test(timeout=60000L)
    public void testRollbackSomeThenReceiveAndCommit() throws Exception {
        int i;
        int MSG_COUNT = 5;
        int consumeBeforeRollback = 2;
        Connection connection = this.createConnection();
        Session session = connection.createSession(true, 0);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        MessageProducer p = session.createProducer((Destination)queue);
        for (int i2 = 0; i2 < 5; ++i2) {
            TextMessage message = session.createTextMessage();
            message.setText("Message:" + i2);
            message.setIntProperty("MESSAGE_NUMBER", i2 + 1);
            p.send((Message)message);
        }
        session.commit();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        for (int i3 = 1; i3 <= 2; ++i3) {
            Message message = consumer.receive(1000L);
            JMSTransactionTest.assertNotNull((Object)message);
            JMSTransactionTest.assertEquals((String)"Unexpected message number", (long)i3, (long)message.getIntProperty("MESSAGE_NUMBER"));
        }
        session.rollback();
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        HashSet<Integer> messageNumbers = new HashSet<Integer>();
        for (i = 1; i <= 5; ++i) {
            messageNumbers.add(i);
        }
        for (i = 1; i <= 5; ++i) {
            Message message = consumer.receive(1000L);
            JMSTransactionTest.assertNotNull((Object)message);
            int msgNum = message.getIntProperty("MESSAGE_NUMBER");
            messageNumbers.remove(msgNum);
        }
        session.commit();
        JMSTransactionTest.assertTrue((String)("Did not consume all expected messages, missing messages: " + messageNumbers), (boolean)messageNumbers.isEmpty());
        JMSTransactionTest.assertEquals((String)"Queue should have no messages left after commit", (long)0L, (long)queueView.getMessageCount());
    }
}

