/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.util.JMSClusteredTestBase;
import org.junit.Test;

public class TopicClusterPageStoreSizeTest
extends JMSClusteredTestBase {
    public static final String TOPIC = "jms.t1";

    @Test
    public void testPageStoreSizeWithClusteredDurableSub() throws Exception {
        this.doTestPageStoreSizeWithClusteredDurableSub(false);
    }

    @Test
    public void testPageStoreSizeWithClusteredDurableSubWithPaging() throws Exception {
        this.doTestPageStoreSizeWithClusteredDurableSub(true);
    }

    private void doTestPageStoreSizeWithClusteredDurableSub(boolean forcePaging) throws Exception {
        Connection conn1 = this.cf1.createConnection();
        conn1.setClientID("someClient1");
        Connection conn2 = this.cf2.createConnection();
        conn2.setClientID("someClient2");
        conn1.start();
        conn2.start();
        Topic topic1 = this.createTopic(TOPIC, true);
        Session session1 = conn1.createSession(false, 2);
        Session session2 = conn2.createSession(false, 2);
        MessageProducer prod1 = session1.createProducer(null);
        prod1.setDeliveryMode(2);
        TopicSubscriber cons1 = session1.createDurableSubscriber(topic1, "sub1");
        TopicSubscriber cons2 = session2.createDurableSubscriber(topic1, "sub2");
        this.waitForBindings(this.server1, TOPIC, true, 1, 1, 2000L);
        this.waitForBindings(this.server2, TOPIC, true, 1, 1, 2000L);
        this.waitForBindings(this.server1, TOPIC, false, 1, 1, 2000L);
        this.waitForBindings(this.server2, TOPIC, false, 1, 1, 2000L);
        if (forcePaging) {
            for (SimpleString psName : this.server1.getPagingManager().getStoreNames()) {
                System.err.println("server1: force paging on:" + psName);
                this.server1.getPagingManager().getPageStore(psName).startPaging();
            }
            for (SimpleString psName : this.server2.getPagingManager().getStoreNames()) {
                System.err.println("server2: force paging on:" + psName);
                this.server2.getPagingManager().getPageStore(psName).startPaging();
            }
        }
        prod1.send((Destination)topic1, (Message)session1.createTextMessage("someMessage"));
        TextMessage m2 = (TextMessage)cons2.receive(5000L);
        TopicClusterPageStoreSizeTest.assertNotNull((Object)m2);
        TopicClusterPageStoreSizeTest.assertTrue((boolean)m2.getJMSDestination().toString().contains(TOPIC));
        System.err.println("sub2 on 2, no ack, message txt:" + m2.getText());
        TextMessage m1 = (TextMessage)cons1.receive(5000L);
        TopicClusterPageStoreSizeTest.assertNotNull((Object)m1);
        TopicClusterPageStoreSizeTest.assertTrue((boolean)m1.getJMSDestination().toString().contains(TOPIC));
        System.err.println("message txt:" + m1.getText());
        m1.acknowledge();
        conn1.close();
        conn2.close();
        for (SimpleString simpleString : this.server1.getPagingManager().getStoreNames()) {
            TopicClusterPageStoreSizeTest.assertTrue((String)("non negative size: " + simpleString), (this.server1.getPagingManager().getPageStore(simpleString).getAddressSize() >= 0L ? (byte)1 : 0) != 0);
        }
        for (SimpleString simpleString : this.server2.getPagingManager().getStoreNames()) {
            System.err.println("server2: size of pages store: " + simpleString + " :" + this.server2.getPagingManager().getPageStore(simpleString).getAddressSize());
            TopicClusterPageStoreSizeTest.assertTrue((String)("non negative size: " + simpleString), (this.server2.getPagingManager().getPageStore(simpleString).getAddressSize() >= 0L ? (byte)1 : 0) != 0);
        }
        if (forcePaging) {
            TopicClusterPageStoreSizeTest.assertTrue((String)"size on 2", (this.server2.getPagingManager().getPageStore(SimpleString.toSimpleString((String)TOPIC)).getNumberOfPages() > 0 ? (byte)1 : 0) != 0);
        } else {
            TopicClusterPageStoreSizeTest.assertTrue((String)"size on 2", (this.server2.getPagingManager().getPageStore(SimpleString.toSimpleString((String)TOPIC)).getAddressSize() > 0L ? (byte)1 : 0) != 0);
        }
        conn1 = this.cf1.createConnection();
        conn1.setClientID("someClient2");
        conn1.start();
        session1 = conn1.createSession(false, 2);
        cons1 = session1.createDurableSubscriber(topic1, "sub2");
        m2 = (TextMessage)cons1.receive(5000L);
        TopicClusterPageStoreSizeTest.assertNotNull((Object)m2);
        TopicClusterPageStoreSizeTest.assertTrue((boolean)m2.getJMSDestination().toString().contains(TOPIC));
        System.err.println("sub2 on 1, message txt:" + m2.getText());
        m2.acknowledge();
        prod1 = session1.createProducer(null);
        prod1.setDeliveryMode(2);
        prod1.send((Destination)topic1, (Message)session1.createTextMessage("someOtherMessage"));
        TopicClusterPageStoreSizeTest.assertTrue((String)"some size on 1", (this.server1.getPagingManager().getPageStore(SimpleString.toSimpleString((String)TOPIC)).getAddressSize() > 0L ? (byte)1 : 0) != 0);
        TopicClusterPageStoreSizeTest.assertTrue((String)"no size on 2", (this.server2.getPagingManager().getPageStore(SimpleString.toSimpleString((String)TOPIC)).getAddressSize() == 0L ? (byte)1 : 0) != 0);
        conn2 = this.cf2.createConnection();
        conn2.setClientID("someClient2");
        conn2.start();
        session2 = conn2.createSession(false, 2);
        cons2 = session2.createDurableSubscriber(topic1, "sub2");
        m2 = (TextMessage)cons2.receiveNoWait();
        TopicClusterPageStoreSizeTest.assertNull((String)"did not get message", (Object)m2);
        m2 = (TextMessage)cons1.receive(5000L);
        TopicClusterPageStoreSizeTest.assertNotNull((String)"got message", (Object)m2);
        TopicClusterPageStoreSizeTest.assertTrue((boolean)m2.getJMSDestination().toString().contains(TOPIC));
        System.err.println("sub2 on 1, message txt:" + m2.getText());
        m2.acknowledge();
        prod1.send((Destination)topic1, (Message)session1.createTextMessage("someOtherOtherMessage"));
        m2 = (TextMessage)cons2.receive(5000L);
        TopicClusterPageStoreSizeTest.assertNotNull((String)"got message", (Object)m2);
        TopicClusterPageStoreSizeTest.assertTrue((boolean)m2.getJMSDestination().toString().contains(TOPIC));
        System.err.println("sub2 on 2: message txt:" + m2.getText());
        m2.acknowledge();
        m2 = (TextMessage)cons1.receiveNoWait();
        TopicClusterPageStoreSizeTest.assertNull((String)"non null message", (Object)m2);
        conn1.close();
        conn2.close();
        for (SimpleString simpleString : new ConnectionFactory[]{this.cf2, this.cf1}) {
            conn2 = simpleString.createConnection();
            conn2.setClientID("someClient1");
            conn2.start();
            session2 = conn2.createSession(false, 2);
            cons2 = session2.createDurableSubscriber(topic1, "sub1");
            m2 = (TextMessage)cons2.receive(5000L);
            TopicClusterPageStoreSizeTest.assertNotNull((String)"got message", (Object)m2);
            TopicClusterPageStoreSizeTest.assertTrue((boolean)m2.getJMSDestination().toString().contains(TOPIC));
            System.err.println("sub1 on: " + simpleString + " - message txt:" + m2.getText());
            m2.acknowledge();
            conn2.close();
        }
    }
}

