/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.SequentialFileFactoryTestBase;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class AIOSequentialFileFactoryTest
extends SequentialFileFactoryTestBase {
    @BeforeClass
    public static void hasAIO() {
        Assume.assumeTrue((String)"Test case needs AIO to run", (boolean)AIOSequentialFileFactory.isSupported());
    }

    @Override
    protected SequentialFileFactory createFactory(String folder) {
        return new AIOSequentialFileFactory(new File(folder), 10);
    }

    @Test
    public void canCreateFactoryWithMaxIOLessThenTwo() {
        AIOSequentialFileFactory factory = new AIOSequentialFileFactory(new File("ignore"), 1);
    }

    @Test
    public void testBuffer() throws Exception {
        SequentialFile file = this.factory.createSequentialFile("filtetmp.log");
        file.open();
        ByteBuffer buff = this.factory.newBuffer(10);
        Assert.assertEquals((long)this.factory.getAlignment(), (long)buff.limit());
        file.close();
        this.factory.releaseBuffer(buff);
    }
}

