/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JmsConnectionStartStopTest
extends BasicOpenWireTest {
    private Connection startedConnection;
    private Connection stoppedConnection;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.startedConnection = this.factory.createConnection();
        this.startedConnection.start();
        this.stoppedConnection = this.factory.createConnection();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.stoppedConnection.close();
        this.startedConnection.close();
        super.tearDown();
    }

    @Test
    public void testStoppedConsumerHoldsMessagesTillStarted() throws JMSException {
        Session startedSession = this.startedConnection.createSession(false, 1);
        Session stoppedSession = this.stoppedConnection.createSession(false, 1);
        Topic topic = startedSession.createTopic("test");
        MessageConsumer startedConsumer = startedSession.createConsumer((Destination)topic);
        MessageConsumer stoppedConsumer = stoppedSession.createConsumer((Destination)topic);
        MessageProducer producer = startedSession.createProducer((Destination)topic);
        TextMessage message = startedSession.createTextMessage("Hello");
        producer.send((Message)message);
        Message m = startedConsumer.receive(1000L);
        JmsConnectionStartStopTest.assertNotNull((Object)m);
        m = stoppedConsumer.receive(1000L);
        JmsConnectionStartStopTest.assertNull((Object)m);
        this.stoppedConnection.start();
        m = stoppedConsumer.receive(5000L);
        JmsConnectionStartStopTest.assertNotNull((Object)m);
        startedSession.close();
        stoppedSession.close();
    }

    @Test
    public void testMultipleConnectionStops() throws Exception {
        this.testStoppedConsumerHoldsMessagesTillStarted();
        this.stoppedConnection.stop();
        this.testStoppedConsumerHoldsMessagesTillStarted();
        this.stoppedConnection.stop();
        this.testStoppedConsumerHoldsMessagesTillStarted();
    }

    @Test
    public void testConcurrentSessionCreateWithStart() throws Exception {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(50, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        final Vector exceptions = new Vector();
        final AtomicInteger counter = new AtomicInteger(0);
        final Random rand = new Random();
        Runnable createSessionTask = new Runnable(){

            @Override
            public void run() {
                try {
                    TimeUnit.MILLISECONDS.sleep(rand.nextInt(10));
                    JmsConnectionStartStopTest.this.stoppedConnection.createSession(false, 1);
                    counter.incrementAndGet();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        Runnable startStopTask = new Runnable(){

            @Override
            public void run() {
                try {
                    TimeUnit.MILLISECONDS.sleep(rand.nextInt(10));
                    JmsConnectionStartStopTest.this.stoppedConnection.start();
                    JmsConnectionStartStopTest.this.stoppedConnection.stop();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        for (int i = 0; i < 1000; ++i) {
            executor.execute(createSessionTask);
            executor.execute(startStopTask);
        }
        executor.shutdown();
        JmsConnectionStartStopTest.assertTrue((String)"executor terminated", (boolean)executor.awaitTermination(30L, TimeUnit.SECONDS));
        JmsConnectionStartStopTest.assertTrue((String)("no exceptions: " + exceptions), (boolean)exceptions.isEmpty());
    }
}

