/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import org.apache.activemq.artemis.tests.integration.openwire.amq.JmsSendReceiveTestSupport;
import org.junit.After;
import org.junit.Before;

public class JmsTopicSendReceiveWithTwoConnectionsTest
extends JmsSendReceiveTestSupport {
    protected Connection sendConnection;
    protected Connection receiveConnection;
    protected Session receiveSession;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.sendConnection = this.createSendConnection();
        this.sendConnection.start();
        this.receiveConnection = this.createReceiveConnection();
        this.receiveConnection.start();
        this.session = this.createSendSession(this.sendConnection);
        this.receiveSession = this.createReceiveSession(this.receiveConnection);
        this.producer = this.session.createProducer(null);
        this.producer.setDeliveryMode(this.deliveryMode);
        if (this.topic) {
            this.consumerDestination = this.createDestination(this.session, (byte)2);
            this.producerDestination = this.createDestination(this.session, (byte)2);
        } else {
            this.consumerDestination = this.createDestination(this.session, (byte)1);
            this.producerDestination = this.createDestination(this.session, (byte)1);
        }
        this.consumer = this.createConsumer(this.receiveSession, this.consumerDestination);
        this.consumer.setMessageListener((MessageListener)this);
    }

    protected Session createReceiveSession(Connection receiveConnection) throws Exception {
        return receiveConnection.createSession(false, 1);
    }

    protected Session createSendSession(Connection sendConnection) throws Exception {
        return sendConnection.createSession(false, 1);
    }

    protected Connection createReceiveConnection() throws Exception {
        return this.createConnection();
    }

    protected Connection createSendConnection() throws Exception {
        return this.createConnection();
    }

    protected MessageConsumer createConsumer(Session session, Destination dest) throws JMSException {
        return session.createConsumer(dest);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.session.close();
        this.receiveSession.close();
        this.sendConnection.close();
        this.receiveConnection.close();
        super.tearDown();
    }
}

