/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.junit.After;
import org.junit.Before;

public class ProducerFlowControlBaseTest
extends BasicOpenWireTest {
    ActiveMQQueue queueA = new ActiveMQQueue("QUEUE.A");
    ActiveMQQueue queueB = new ActiveMQQueue("QUEUE.B");
    protected ActiveMQConnection flowControlConnection;
    protected final AtomicBoolean gotResourceException = new AtomicBoolean(false);
    private Thread asyncThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillQueue(final ActiveMQQueue queue) throws JMSException, InterruptedException {
        final AtomicBoolean done = new AtomicBoolean(true);
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        try {
            this.asyncThread = new Thread("Fill thread."){

                @Override
                public void run() {
                    Session session = null;
                    try {
                        session = ProducerFlowControlBaseTest.this.flowControlConnection.createSession(false, 1);
                        MessageProducer producer = session.createProducer((Destination)queue);
                        producer.setDeliveryMode(1);
                        while (keepGoing.get()) {
                            done.set(false);
                            producer.send((Message)session.createTextMessage("Hello World"));
                        }
                    }
                    catch (JMSException jMSException) {
                        ProducerFlowControlBaseTest.this.safeClose(session);
                    }
                    catch (Throwable throwable) {
                        ProducerFlowControlBaseTest.this.safeClose(session);
                        throw throwable;
                    }
                    ProducerFlowControlBaseTest.this.safeClose(session);
                }
            };
            this.asyncThread.start();
            this.waitForBlockedOrResourceLimit(done);
        }
        finally {
            keepGoing.set(false);
        }
    }

    protected void waitForBlockedOrResourceLimit(AtomicBoolean done) throws InterruptedException {
        while (true) {
            Thread.sleep(100L);
            if (done.get() || this.gotResourceException.get()) break;
            done.set(true);
        }
    }

    protected CountDownLatch asyncSendTo(final ActiveMQQueue queue, final String message) throws JMSException {
        final CountDownLatch done = new CountDownLatch(1);
        new Thread("Send thread."){

            @Override
            public void run() {
                Session session = null;
                try {
                    session = ProducerFlowControlBaseTest.this.flowControlConnection.createSession(false, 1);
                    MessageProducer producer = session.createProducer((Destination)queue);
                    producer.setDeliveryMode(1);
                    producer.send((Message)session.createTextMessage(message));
                    done.countDown();
                }
                catch (JMSException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        ProducerFlowControlBaseTest.this.safeClose(session);
                        throw throwable;
                    }
                    ProducerFlowControlBaseTest.this.safeClose(session);
                }
                ProducerFlowControlBaseTest.this.safeClose(session);
            }
        }.start();
        return done;
    }

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        String match = "#";
        Map asMap = serverConfig.getAddressesSettings();
        ((AddressSettings)asMap.get(match)).setMaxSizeBytes(1L).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.makeSureCoreQueueExist("QUEUE.A");
        this.makeSureCoreQueueExist("QUEUE.B");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            if (this.flowControlConnection != null) {
                TcpTransport t = (TcpTransport)this.flowControlConnection.getTransport().narrow(TcpTransport.class);
                try {
                    this.flowControlConnection.getTransport().stop();
                    this.flowControlConnection.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                t.getTransportListener().onException(new IOException("Disposed."));
            }
            if (this.asyncThread != null) {
                this.asyncThread.join();
                this.asyncThread = null;
            }
        }
        finally {
            super.tearDown();
        }
    }
}

