/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.ValueAtPercentile;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryPointData;
import java.util.List;

final class AutoValue_ImmutableSummaryPointData
extends ImmutableSummaryPointData {
    private final long startEpochNanos;
    private final long epochNanos;
    private final Attributes attributes;
    private final List<ExemplarData> exemplars;
    private final long count;
    private final double sum;
    private final List<ValueAtPercentile> percentileValues;

    AutoValue_ImmutableSummaryPointData(long startEpochNanos, long epochNanos, Attributes attributes, List<ExemplarData> exemplars, long count, double sum, List<ValueAtPercentile> percentileValues) {
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        if (attributes == null) {
            throw new NullPointerException("Null attributes");
        }
        this.attributes = attributes;
        if (exemplars == null) {
            throw new NullPointerException("Null exemplars");
        }
        this.exemplars = exemplars;
        this.count = count;
        this.sum = sum;
        if (percentileValues == null) {
            throw new NullPointerException("Null percentileValues");
        }
        this.percentileValues = percentileValues;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public List<ExemplarData> getExemplars() {
        return this.exemplars;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public List<ValueAtPercentile> getPercentileValues() {
        return this.percentileValues;
    }

    public String toString() {
        return "ImmutableSummaryPointData{startEpochNanos=" + this.startEpochNanos + ", epochNanos=" + this.epochNanos + ", attributes=" + this.attributes + ", exemplars=" + this.exemplars + ", count=" + this.count + ", sum=" + this.sum + ", percentileValues=" + this.percentileValues + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableSummaryPointData) {
            ImmutableSummaryPointData that = (ImmutableSummaryPointData)o;
            return this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && this.attributes.equals(that.getAttributes()) && this.exemplars.equals(that.getExemplars()) && this.count == that.getCount() && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(that.getSum()) && this.percentileValues.equals(that.getPercentileValues());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        h$ *= 1000003;
        h$ ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        h$ *= 1000003;
        h$ ^= this.attributes.hashCode();
        h$ *= 1000003;
        h$ ^= this.exemplars.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.count >>> 32 ^ this.count);
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.sum) >>> 32 ^ Double.doubleToLongBits(this.sum));
        h$ *= 1000003;
        return h$ ^= this.percentileValues.hashCode();
    }
}

