/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.event;

import jakarta.enterprise.event.NotificationOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

class ImmutableNotificationOptions
implements NotificationOptions {
    private final Executor executor;
    private final Map<String, Object> options;

    private ImmutableNotificationOptions(Executor executor, Map<String, Object> options) {
        this.executor = executor;
        this.options = new HashMap<String, Object>(options);
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public Object get(String name) {
        return this.options.get(name);
    }

    static class Builder
    implements NotificationOptions.Builder {
        private Executor executor;
        private Map<String, Object> options = new HashMap<String, Object>();

        Builder() {
        }

        @Override
        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public Builder set(String name, Object value) {
            this.options.put(name, value);
            return this;
        }

        @Override
        public ImmutableNotificationOptions build() {
            return new ImmutableNotificationOptions(this.executor, this.options);
        }
    }
}

