/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Objects;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.parsing.Attribute;

public class GlobalMetricsConfiguration {
    public static final AttributeDefinition<Boolean> GAUGES = AttributeDefinition.builder((String)"gauges", (Object)true).immutable().build();
    public static final AttributeDefinition<Boolean> HISTOGRAMS = AttributeDefinition.builder((String)"histograms", (Object)false).immutable().build();
    public static final AttributeDefinition<String> PREFIX = AttributeDefinition.builder((String)"prefix", (Object)"").immutable().build();
    public static final AttributeDefinition<Boolean> NAMES_AS_TAGS = AttributeDefinition.builder((String)"namesAsTags", (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> ACCURATE_SIZE = AttributeDefinition.builder((Enum)Attribute.ACCURATE_SIZE, (Object)false).build();
    private final AttributeSet attributes;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> gauges;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> histograms;
    private final org.infinispan.commons.configuration.attributes.Attribute<String> prefix;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> namesAsTags;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> accurateSize;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalMetricsConfiguration.class, new AttributeDefinition[]{GAUGES, HISTOGRAMS, PREFIX, NAMES_AS_TAGS, ACCURATE_SIZE});
    }

    GlobalMetricsConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.gauges = attributes.attribute(GAUGES);
        this.histograms = attributes.attribute(HISTOGRAMS);
        this.prefix = attributes.attribute(PREFIX);
        this.namesAsTags = attributes.attribute(NAMES_AS_TAGS);
        this.accurateSize = attributes.attribute(ACCURATE_SIZE);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean enabled() {
        return this.gauges() || this.histograms();
    }

    public boolean gauges() {
        return (Boolean)this.gauges.get();
    }

    public boolean histograms() {
        return (Boolean)this.histograms.get();
    }

    public String prefix() {
        return (String)this.prefix.get();
    }

    public boolean namesAsTags() {
        return (Boolean)this.namesAsTags.get();
    }

    public boolean accurateSize() {
        return (Boolean)this.accurateSize.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalMetricsConfiguration that = (GlobalMetricsConfiguration)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }

    public String toString() {
        return "GlobalMetricsConfiguration{attributes=" + this.attributes + "}";
    }
}

