/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolConfigurationServiceConfigurator;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jgroups.protocols.FD_SOCK2;

public class FailureDetectionProtocolConfigurationServiceConfigurator
extends SocketProtocolConfigurationServiceConfigurator<FD_SOCK2> {
    public FailureDetectionProtocolConfigurationServiceConfigurator(PathAddress address) {
        super(address);
    }

    @Override
    public void accept(FD_SOCK2 protocol) {
        SocketBinding clientBinding;
        List clientMappings;
        SocketBinding protocolBinding = this.getSocketBinding();
        SocketBinding transportBinding = this.getTransport().getSocketBinding();
        SocketBinding binding = protocolBinding != null ? protocolBinding : transportBinding;
        InetSocketAddress socketAddress = binding.getSocketAddress();
        protocol.setBindAddress(socketAddress.getAddress());
        if (protocolBinding != null) {
            protocol.setValue("offset", (Object)(socketAddress.getPort() - transportBinding.getSocketAddress().getPort()));
        }
        if (!(clientMappings = binding.getClientMappings()).isEmpty()) {
            ClientMapping mapping = (ClientMapping)clientMappings.get(0);
            try {
                protocol.setExternalAddress(InetAddress.getByName(mapping.getDestinationAddress()));
                protocol.setExternalPort(mapping.getDestinationPort());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if ((clientBinding = this.getClientSocketBinding()) != null) {
            protocol.setClientBindPort(clientBinding.getSocketAddress().getPort());
        }
    }
}

