/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.jcip.annotations.GuardedBy;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class NonBlockingManagerImpl
implements NonBlockingManager {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @ComponentName(value="org.infinispan.executors.timeout")
    @Inject
    ScheduledExecutorService scheduler;
    @ComponentName(value="org.infinispan.executors.non-blocking")
    @Inject
    Executor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AutoCloseable scheduleWithFixedDelay(Supplier<CompletionStage<?>> supplier, long initialDelay, long delay, TimeUnit unit, Predicate<? super Throwable> mayRepeatOnThrowable) {
        ReschedulingTask task;
        ReschedulingTask reschedulingTask = task = new ReschedulingTask(supplier, delay, unit, mayRepeatOnThrowable);
        synchronized (reschedulingTask) {
            task.future = this.scheduler.schedule(task, initialDelay, unit);
        }
        return task;
    }

    @Override
    public <T> void complete(CompletableFuture<? super T> future, T value) {
        if (future.getNumberOfDependents() > 0) {
            this.executor.execute(() -> future.complete(value));
        } else {
            future.complete(value);
        }
    }

    private class ReschedulingTask
    implements AutoCloseable,
    Runnable {
        @GuardedBy(value="this")
        private Future<?> future;
        private final Supplier<CompletionStage<?>> supplier;
        private final long delay;
        private final TimeUnit unit;
        private final Predicate<? super Throwable> mayRepeatOnThrowable;

        private ReschedulingTask(Supplier<CompletionStage<?>> supplier, long delay, TimeUnit unit, Predicate<? super Throwable> mayRepeatOnThrowable) {
            this.supplier = supplier;
            this.delay = delay;
            this.unit = unit;
            this.mayRepeatOnThrowable = mayRepeatOnThrowable;
        }

        @Override
        public void run() {
            CompletionStage<?> stage = this.supplier.get();
            stage.whenComplete((v, t) -> {
                boolean isRunning;
                if (t != null) {
                    if (this.mayRepeatOnThrowable == null || !this.mayRepeatOnThrowable.test((Throwable)t)) {
                        log.scheduledTaskEncounteredThrowable(this.supplier, (Throwable)t);
                        return;
                    }
                    log.tracef((Throwable)t, "There was an error in submitted periodic non blocking task with supplier %s, configured to resubmit", this.supplier);
                }
                ReschedulingTask reschedulingTask = this;
                synchronized (reschedulingTask) {
                    isRunning = this.future != null;
                }
                if (isRunning) {
                    ScheduledFuture<?> newFuture = NonBlockingManagerImpl.this.scheduler.schedule(this, this.delay, this.unit);
                    boolean shouldCancel = false;
                    ReschedulingTask reschedulingTask2 = this;
                    synchronized (reschedulingTask2) {
                        if (this.future == null) {
                            shouldCancel = true;
                        } else {
                            this.future = newFuture;
                        }
                    }
                    if (shouldCancel) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Periodic non blocking task with supplier %s was cancelled while rescheduling.", this.supplier);
                        }
                        newFuture.cancel(true);
                    }
                } else if (log.isTraceEnabled()) {
                    log.tracef("Periodic non blocking task with supplier %s was cancelled prior to execution.", this.supplier);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws Exception {
            Future<?> cancelFuture;
            if (log.isTraceEnabled()) {
                log.tracef("Periodic non blocking task with supplier %s was cancelled.", this.supplier);
            }
            ReschedulingTask reschedulingTask = this;
            synchronized (reschedulingTask) {
                cancelFuture = this.future;
                this.future = null;
            }
            if (cancelFuture != null) {
                cancelFuture.cancel(false);
            }
        }
    }
}

