/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.cli.commands.activation.ActivationSequenceList;
import org.apache.activemq.artemis.cli.commands.activation.ActivationSequenceSet;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.quorum.DistributedLock;
import org.apache.activemq.artemis.quorum.DistributedPrimitiveManager;
import org.apache.activemq.artemis.quorum.MutableLong;
import org.apache.activemq.artemis.quorum.file.FileBasedPrimitiveManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ActivationSequenceCommandsTest
extends ActiveMQTestBase {
    @Rule
    public TemporaryFolder brokersFolder = new TemporaryFolder();
    protected DistributedPrimitiveManagerConfiguration managerConfiguration;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.managerConfiguration = new DistributedPrimitiveManagerConfiguration(FileBasedPrimitiveManager.class.getName(), Collections.singletonMap("locks-folder", this.temporaryFolder.newFolder("manager").toString()));
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected Configuration createLiveConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::live");
        File liveDir = this.brokersFolder.newFolder("live");
        conf.setBrokerInstance(liveDir);
        conf.addAcceptorConfiguration("live", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        conf.setHAPolicyConfiguration(this.createReplicationLiveConfiguration());
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("backup");
        ccconf.setName("cluster");
        ccconf.setConnectorName("live");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    protected Configuration createBackupConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::backup");
        File backupDir = this.brokersFolder.newFolder("backup");
        conf.setBrokerInstance(backupDir);
        conf.setHAPolicyConfiguration(this.createReplicationBackupConfiguration());
        conf.addAcceptorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("live");
        ccconf.setName("cluster");
        ccconf.setConnectorName("backup");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    protected HAPolicyConfiguration createReplicationLiveConfiguration() {
        ReplicationPrimaryPolicyConfiguration haPolicy = ReplicationPrimaryPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        return haPolicy;
    }

    protected HAPolicyConfiguration createReplicationBackupConfiguration() {
        ReplicationBackupPolicyConfiguration haPolicy = ReplicationBackupPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        haPolicy.setClusterName("cluster");
        return haPolicy;
    }

    @Test
    public void restorePrimaryCoordinatedSequence() throws Exception {
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.setIdentity("LIVE");
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        String nodeID = liveServer.getNodeID().toString();
        liveServer.stop();
        this.restoreCoordinatedSequence(liveConfiguration, liveServer, nodeID, 1L);
    }

    @Test
    public void restoreBackupCoordinatedSequence() throws Exception {
        int timeout = (int)TimeUnit.SECONDS.toMillis(30L);
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer primaryInstance = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        primaryInstance.setIdentity("PRIMARY");
        primaryInstance.start();
        Assert.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Configuration backupConfiguration = this.createBackupConfiguration();
        ((ReplicationBackupPolicyConfiguration)backupConfiguration.getHAPolicyConfiguration()).setAllowFailBack(true);
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted());
        Wait.assertTrue(() -> backupServer.isReplicaSync(), (long)timeout);
        Assert.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Assert.assertEquals((long)1L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        primaryInstance.stop();
        Wait.assertTrue(() -> 2L == backupServer.getNodeManager().getNodeActivationSequence(), (long)timeout);
        String nodeId = backupServer.getNodeManager().getNodeId().toString();
        backupServer.stop();
        this.restoreCoordinatedSequence(backupConfiguration, backupServer, nodeId, 2L);
    }

    @Test
    public void restorePeerCoordinatedSequence() throws Exception {
        Configuration liveConfiguration = this.createLiveConfiguration();
        ((ReplicationPrimaryPolicyConfiguration)liveConfiguration.getHAPolicyConfiguration()).setCoordinationId("peer-id");
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.setIdentity("LIVE");
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        String nodeID = liveServer.getNodeID().toString();
        liveServer.stop();
        this.restoreCoordinatedSequence(liveConfiguration, liveServer, nodeID, 1L);
    }

    private void restoreCoordinatedSequence(Configuration liveConfiguration, ActiveMQServer liveServer, String nodeID, long expectedStartCoordinatedSequence) throws Exception {
        ActivationSequenceList sequenceList = new ActivationSequenceList();
        ActivationSequenceList.ListResult list = ActivationSequenceList.execute((ActivationSequenceList)sequenceList, (Configuration)liveConfiguration, null);
        Assert.assertEquals((long)expectedStartCoordinatedSequence, (long)list.coordinatedActivationSequence);
        Assert.assertEquals((long)expectedStartCoordinatedSequence, (long)list.localActivationSequence);
        try (DistributedPrimitiveManager distributedPrimitiveManager = DistributedPrimitiveManager.newInstanceOf((String)this.managerConfiguration.getClassName(), (Map)this.managerConfiguration.getProperties());){
            distributedPrimitiveManager.start();
            try (DistributedLock lock = distributedPrimitiveManager.getDistributedLock(nodeID);
                 MutableLong coordinatedActivationSequence = distributedPrimitiveManager.getMutableLong(nodeID);){
                Assert.assertTrue((boolean)lock.tryLock());
                long activationSequence = coordinatedActivationSequence.get();
                Assert.assertEquals((long)expectedStartCoordinatedSequence, (long)activationSequence);
                coordinatedActivationSequence.set(0L);
            }
            sequenceList.remote = true;
            Assert.assertEquals((long)0L, (long)ActivationSequenceList.execute((ActivationSequenceList)sequenceList, (Configuration)liveConfiguration, null).coordinatedActivationSequence);
            ActivationSequenceSet sequenceSet = new ActivationSequenceSet();
            sequenceSet.remote = true;
            sequenceSet.value = expectedStartCoordinatedSequence;
            ActivationSequenceSet.execute((ActivationSequenceSet)sequenceSet, (Configuration)liveConfiguration, null);
            liveServer.start();
            org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
            Assert.assertTrue((boolean)liveServer.isActive());
            Assert.assertEquals((long)(expectedStartCoordinatedSequence + 1L), (long)liveServer.getNodeManager().getNodeActivationSequence());
            liveServer.stop();
        }
    }
}

