/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.management.impl.QueueControlImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.client.LargeMessageTest;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class LargeMessageCompressTest
extends LargeMessageTest {
    public LargeMessageCompressTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
        this.isCompressedTest = true;
    }

    @Override
    protected void validateLargeMessageComplete(ActiveMQServer server) throws Exception {
    }

    @Override
    protected boolean isNetty() {
        return false;
    }

    protected ServerLocator createFactory(boolean isNetty) throws Exception {
        return super.createFactory(isNetty).setCompressLargeMessage(true);
    }

    @Test
    public void testLargeMessageCompressionNotCompressedAndBrowsed() throws Exception {
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(new QueueConfiguration(this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        clientFile.setType((byte)3);
        producer.send((Message)clientFile);
        session.commit();
        session.close();
        QueueControlImpl queueControl = (QueueControlImpl)server.getManagementService().getResource("queue.SimpleAddress");
        CompositeData[] browse = queueControl.browse();
        Assert.assertNotNull((Object)browse);
        Assert.assertEquals((long)browse.length, (long)1L);
        Assert.assertEquals((Object)browse[0].get("text"), (Object)"[compressed]");
        session = this.addClientSession(sf.createSession(false, false, false));
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg1);
        for (int i = 0; i < 358400; ++i) {
            byte b = msg1.getBodyBuffer().readByte();
            LargeMessageCompressTest.assertEquals((String)("position = " + i), (long)LargeMessageCompressTest.getSamplebyte((long)i), (long)b);
        }
        msg1.acknowledge();
        session.commit();
        consumer.close();
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @Test
    public void testNoDirectByteBufLeaksOnLargeMessageCompression() throws Exception {
        Assume.assumeThat((Object)PlatformDependent.usedDirectMemory(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)-1L)));
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(new QueueConfiguration(this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        long usedDirectMemoryBeforeReceive = PlatformDependent.usedDirectMemory();
        ClientMessage msg1 = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg1);
        long usedDirectMemoryAfterReceive = PlatformDependent.usedDirectMemory();
        Assert.assertEquals((String)"large message compression is leaking some Netty direct ByteBuff", (long)usedDirectMemoryBeforeReceive, (long)usedDirectMemoryAfterReceive);
        msg1.acknowledge();
        session.commit();
        consumer.close();
        session.close();
    }

    @Test
    public void testLargeMessageCompression() throws Exception {
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(new QueueConfiguration(this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg1);
        for (int i = 0; i < 358400; ++i) {
            byte b = msg1.getBodyBuffer().readByte();
            LargeMessageCompressTest.assertEquals((String)("position = " + i), (long)LargeMessageCompressTest.getSamplebyte((long)i), (long)b);
        }
        msg1.acknowledge();
        session.commit();
        consumer.close();
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @Test
    public void testLargeMessageCompression2() throws Exception {
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(new QueueConfiguration(this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg1);
        String testDir = this.getTestDir();
        File testFile = new File(testDir, "async_large_message");
        FileOutputStream output = new FileOutputStream(testFile);
        msg1.setOutputStream((OutputStream)output);
        msg1.waitOutputStreamCompletion(0L);
        msg1.acknowledge();
        output.close();
        session.commit();
        consumer.close();
        session.close();
        FileInputStream input = new FileInputStream(testFile);
        for (int i = 0; i < 358400; ++i) {
            byte b = (byte)input.read();
            LargeMessageCompressTest.assertEquals((String)("position = " + i), (long)LargeMessageCompressTest.getSamplebyte((long)i), (long)b);
        }
        input.close();
        testFile.delete();
        this.validateNoFilesOnLargeDir();
    }

    @Test
    public void testLargeMessageCompression3() throws Exception {
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(new QueueConfiguration(this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg1);
        String testDir = this.getTestDir();
        File testFile = new File(testDir, "async_large_message");
        FileOutputStream output = new FileOutputStream(testFile);
        msg1.saveToOutputStream((OutputStream)output);
        msg1.acknowledge();
        output.close();
        session.commit();
        consumer.close();
        session.close();
        FileInputStream input = new FileInputStream(testFile);
        for (int i = 0; i < 358400; ++i) {
            byte b = (byte)input.read();
            LargeMessageCompressTest.assertEquals((String)("position = " + i), (long)LargeMessageCompressTest.getSamplebyte((long)i), (long)b);
        }
        input.close();
        testFile.delete();
        this.validateNoFilesOnLargeDir();
    }

    @Test
    public void testHugeStreamingSpacesCompressed() throws Exception {
        long messageSize = 0x100000L;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        this.locator.setMinLargeMessageSize(0x6400000);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(new QueueConfiguration(this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientMessage = session.createMessage(true);
        clientMessage.setBodyInputStream(new InputStream(){
            private long count;
            private boolean closed = false;

            @Override
            public void close() throws IOException {
                super.close();
                this.closed = true;
            }

            @Override
            public int read() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream was closed");
                }
                if (this.count++ < 0x100000L) {
                    return 32;
                }
                return -1;
            }
        });
        producer.send((Message)clientMessage);
        session.commit();
        this.validateNoFilesOnLargeDir();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg1);
        final AtomicLong numberOfSpaces = new AtomicLong();
        msg1.saveToOutputStream(new OutputStream(){

            @Override
            public void write(int content) {
                if (content == 32) {
                    numberOfSpaces.incrementAndGet();
                }
            }
        });
        LargeMessageCompressTest.assertEquals((long)0x100000L, (long)numberOfSpaces.get());
        msg1.acknowledge();
        session.commit();
        session.close();
    }

    @Test
    public void testLargeMessageCompressionRestartAndCheckSize() throws Exception {
        int messageSize = 0x100000;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(new QueueConfiguration(this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        byte[] msgs = new byte[0x100000];
        for (int i = 0; i < msgs.length; ++i) {
            msgs[i] = RandomUtil.randomByte();
        }
        ClientMessage clientFile = this.createLargeClientMessage(session, msgs, true);
        producer.send((Message)clientFile);
        session.commit();
        session.close();
        sf.close();
        this.locator.close();
        server.stop();
        server = this.createServer(true, this.isNetty());
        server.start();
        this.locator = this.createFactory(this.isNetty());
        sf = this.createSessionFactory(this.locator);
        session = sf.createSession();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg1);
        LargeMessageCompressTest.assertEquals((long)0x100000L, (long)msg1.getBodySize());
        String testDir = this.getTestDir();
        File testFile = new File(testDir, "async_large_message");
        FileOutputStream output = new FileOutputStream(testFile);
        msg1.saveToOutputStream((OutputStream)output);
        msg1.acknowledge();
        session.commit();
        consumer.close();
        session.close();
        FileInputStream input = new FileInputStream(testFile);
        for (int i = 0; i < 0x100000; ++i) {
            byte b = (byte)input.read();
            LargeMessageCompressTest.assertEquals((String)("position = " + i), (long)msgs[i], (long)b);
        }
        input.close();
        testFile.delete();
        this.validateNoFilesOnLargeDir();
    }

    @Override
    @Test
    public void testSendServerMessage() throws Exception {
    }
}

