/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Random;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.server.cluster.MessageFlowRecord;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.Before;
import org.junit.Test;

public class ClusterConnectionConfigTest
extends ClusterTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.start();
    }

    private void start() throws Exception {
        this.setupServers();
    }

    protected boolean isNetty() {
        return true;
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType, ClusterTestBase.ClusterConfigCallback cb) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), cb, 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), cb, 1, 0, 2);
    }

    @Test
    public void testRedistributionFlowControl() throws Exception {
        int producerWindow = new Random().nextInt(Integer.MAX_VALUE);
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND, cfg -> cfg.setProducerWindowSize(producerWindow));
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 0, false);
        this.send(0, "queues.testaddress", 1, false, null);
        Thread.sleep(5000L);
        this.makeSureForwardingFlowControl(producerWindow, 0, 1);
        this.removeConsumer(1);
    }

    private void makeSureForwardingFlowControl(int producerWindow, int ... indices) throws NoSuchFieldException, IllegalAccessException {
        for (int i : indices) {
            ClusterConnectionImpl cc = (ClusterConnectionImpl)this.servers[i].getClusterManager().getClusterConnection("cluster" + i);
            Map map = cc.getRecords();
            ClusterConnectionConfigTest.assertEquals((long)1L, (long)map.size());
            MessageFlowRecord record = (MessageFlowRecord)map.entrySet().iterator().next().getValue();
            Field f = record.getClass().getDeclaredField("targetLocator");
            f.setAccessible(true);
            ServerLocatorInternal targetLocator = (ServerLocatorInternal)f.get(record);
            ClusterConnectionConfigTest.assertEquals((long)producerWindow, (long)targetLocator.getProducerWindowSize());
        }
    }
}

