/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.Before;
import org.junit.Test;

public class SharedStoreDontWaitForActivationTest
extends ClusterTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
    }

    private void setupServers() throws Exception {
        this.setupBackupServer(0, 1, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupLiveServer(1, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupSharedStoreMasterPolicy(0);
        this.setupSharedStoreMasterPolicy(1);
        this.setupClusterConnection("cluster", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
    }

    private void setupSharedStoreMasterPolicy(int node) {
        ActiveMQServer server = this.getServer(node);
        SharedStoreMasterPolicyConfiguration liveConfiguration = new SharedStoreMasterPolicyConfiguration();
        liveConfiguration.setFailoverOnServerShutdown(true);
        liveConfiguration.setWaitForActivation(Boolean.valueOf(false));
        Configuration config = server.getConfiguration();
        config.setHAPolicyConfiguration((HAPolicyConfiguration)liveConfiguration);
    }

    private boolean isNetty() {
        return true;
    }

    @Test
    public void startupLiveAndBackups() throws Exception {
        ActiveMQServer server0 = this.getServer(0);
        ActiveMQServer server1 = this.getServer(1);
        server0.start();
        SharedStoreDontWaitForActivationTest.assertTrue((boolean)server0.waitForActivation(5L, TimeUnit.SECONDS));
        server1.start();
        SharedStoreDontWaitForActivationTest.assertFalse((boolean)server1.waitForActivation(1L, TimeUnit.SECONDS));
        this.setupSessionFactory(0, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        server0.stop();
        SharedStoreDontWaitForActivationTest.assertTrue((boolean)server1.waitForActivation(5L, TimeUnit.SECONDS));
        server0.start();
        SharedStoreDontWaitForActivationTest.assertFalse((boolean)server0.waitForActivation(1L, TimeUnit.SECONDS));
        server1.stop();
        SharedStoreDontWaitForActivationTest.assertTrue((boolean)server0.waitForActivation(5L, TimeUnit.SECONDS));
        server1.start();
        SharedStoreDontWaitForActivationTest.assertFalse((boolean)server1.waitForActivation(1L, TimeUnit.SECONDS));
    }
}

