/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.BridgeControl;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.tests.integration.SimpleNotificationService;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BridgeControlTest
extends ManagementTestBase {
    private ActiveMQServer server_0;
    private ActiveMQServer server_1;
    private BridgeConfiguration bridgeConfig;

    @Test
    public void testAttributes() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(this.bridgeConfig.getName()));
        BridgeControl bridgeControl = this.createBridgeControl(this.bridgeConfig.getName(), this.mbeanServer);
        Assert.assertEquals((Object)this.bridgeConfig.getName(), (Object)bridgeControl.getName());
        Assert.assertEquals((Object)this.bridgeConfig.getDiscoveryGroupName(), (Object)bridgeControl.getDiscoveryGroupName());
        Assert.assertEquals((Object)this.bridgeConfig.getQueueName(), (Object)bridgeControl.getQueueName());
        Assert.assertEquals((Object)this.bridgeConfig.getForwardingAddress(), (Object)bridgeControl.getForwardingAddress());
        Assert.assertEquals((Object)this.bridgeConfig.getFilterString(), (Object)bridgeControl.getFilterString());
        Assert.assertEquals((long)this.bridgeConfig.getRetryInterval(), (long)bridgeControl.getRetryInterval());
        Assert.assertEquals((double)this.bridgeConfig.getRetryIntervalMultiplier(), (double)bridgeControl.getRetryIntervalMultiplier(), (double)1.0E-6);
        Assert.assertEquals((long)this.bridgeConfig.getMaxRetryInterval(), (long)bridgeControl.getMaxRetryInterval());
        Assert.assertEquals((long)this.bridgeConfig.getReconnectAttempts(), (long)bridgeControl.getReconnectAttempts());
        Assert.assertEquals((Object)this.bridgeConfig.isUseDuplicateDetection(), (Object)bridgeControl.isUseDuplicateDetection());
        Map bridgeMetrics = bridgeControl.getMetrics();
        Assert.assertEquals((long)0L, (long)bridgeControl.getMessagesPendingAcknowledgement());
        Assert.assertEquals((long)0L, (long)bridgeControl.getMessagesAcknowledged());
        Assert.assertEquals((Object)0L, bridgeMetrics.get("messagesPendingAcknowledgement"));
        Assert.assertEquals((Object)0L, bridgeMetrics.get("messagesAcknowledged"));
        String[] connectorPairData = bridgeControl.getStaticConnectors();
        Assert.assertEquals(this.bridgeConfig.getStaticConnectors().get(0), (Object)connectorPairData[0]);
        Assert.assertTrue((boolean)bridgeControl.isStarted());
    }

    @Test
    public void testStartStop() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(this.bridgeConfig.getName()));
        BridgeControl bridgeControl = this.createBridgeControl(this.bridgeConfig.getName(), this.mbeanServer);
        Assert.assertTrue((boolean)bridgeControl.isStarted());
        bridgeControl.stop();
        Assert.assertFalse((boolean)bridgeControl.isStarted());
        bridgeControl.start();
        Assert.assertTrue((boolean)bridgeControl.isStarted());
    }

    @Test
    public void testNotifications() throws Exception {
        SimpleNotificationService.Listener notifListener = new SimpleNotificationService.Listener();
        BridgeControl bridgeControl = this.createBridgeControl(this.bridgeConfig.getName(), this.mbeanServer);
        this.server_0.getManagementService().addNotificationListener((NotificationListener)notifListener);
        Assert.assertEquals((long)0L, (long)notifListener.getNotifications().size());
        bridgeControl.stop();
        Assert.assertEquals((long)1L, (long)notifListener.getNotifications().size());
        Notification notif = notifListener.getNotifications().get(0);
        Assert.assertEquals((Object)CoreNotificationType.BRIDGE_STOPPED, (Object)notif.getType());
        Assert.assertEquals((Object)bridgeControl.getName(), (Object)notif.getProperties().getSimpleStringProperty(new SimpleString("name")).toString());
        bridgeControl.start();
        Assert.assertEquals((long)2L, (long)notifListener.getNotifications().size());
        notif = notifListener.getNotifications().get(1);
        Assert.assertEquals((Object)CoreNotificationType.BRIDGE_STARTED, (Object)notif.getType());
        Assert.assertEquals((Object)bridgeControl.getName(), (Object)notif.getProperties().getSimpleStringProperty(new SimpleString("name")).toString());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Integer> acceptorParams = new HashMap<String, Integer>();
        acceptorParams.put("serverId", 1);
        TransportConfiguration acceptorConfig = new TransportConfiguration(InVMAcceptorFactory.class.getName(), acceptorParams, RandomUtil.randomString());
        TransportConfiguration connectorConfig = new TransportConfiguration(InVMConnectorFactory.class.getName(), acceptorParams, RandomUtil.randomString());
        QueueConfiguration sourceQueueConfig = new QueueConfiguration(RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        QueueConfiguration targetQueueConfig = new QueueConfiguration(RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        ArrayList<String> connectors = new ArrayList<String>();
        connectors.add(connectorConfig.getName());
        ConfigurationImpl conf_1 = this.createBasicConfig().addAcceptorConfiguration(acceptorConfig).addQueueConfiguration(targetQueueConfig);
        this.bridgeConfig = new BridgeConfiguration().setName(RandomUtil.randomString()).setQueueName(sourceQueueConfig.getName().toString()).setForwardingAddress(targetQueueConfig.getAddress().toString()).setRetryInterval(RandomUtil.randomPositiveLong()).setRetryIntervalMultiplier(RandomUtil.randomDouble()).setInitialConnectAttempts(RandomUtil.randomPositiveInt()).setReconnectAttempts(RandomUtil.randomPositiveInt()).setReconnectAttemptsOnSameNode(RandomUtil.randomPositiveInt()).setUseDuplicateDetection(RandomUtil.randomBoolean()).setConfirmationWindowSize(RandomUtil.randomPositiveInt()).setStaticConnectors(connectors).setPassword("UnitTestsClusterPassword");
        ConfigurationImpl conf_0 = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName())).addConnectorConfiguration(connectorConfig.getName(), connectorConfig).addQueueConfiguration(sourceQueueConfig).addBridgeConfiguration(this.bridgeConfig);
        this.server_1 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_1, (MBeanServer)MBeanServerFactory.createMBeanServer(), (boolean)false));
        this.addServer(this.server_1);
        this.server_1.start();
        this.server_0 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_0, (MBeanServer)this.mbeanServer, (boolean)false));
        this.addServer(this.server_0);
        this.server_0.start();
    }

    protected BridgeControl createBridgeControl(String name, MBeanServer mbeanServer1) throws Exception {
        return ManagementControlHelper.createBridgeControl(name, mbeanServer1);
    }
}

