/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.cluster;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.integration.openwire.cluster.OpenWireJMSClusteredTestBase;
import org.apache.activemq.artemis.utils.RetryRule;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TemporaryQueueClusterTest
extends OpenWireJMSClusteredTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(3);
    public static final String QUEUE_NAME = "target";

    @Override
    public boolean isFileStorage() {
        return false;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createAddressInfo(0, QUEUE_NAME, RoutingType.ANYCAST, -1, false);
        this.createAddressInfo(1, QUEUE_NAME, RoutingType.ANYCAST, -1, false);
        this.createQueue(0, QUEUE_NAME, QUEUE_NAME, null, true, null, null, RoutingType.ANYCAST);
        this.createQueue(1, QUEUE_NAME, QUEUE_NAME, null, true, null, null, RoutingType.ANYCAST);
        this.waitForBindings(0, QUEUE_NAME, 1, 0, true);
        this.waitForBindings(0, QUEUE_NAME, 1, 0, false);
        this.waitForBindings(1, QUEUE_NAME, 1, 0, true);
        this.waitForBindings(1, QUEUE_NAME, 1, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusteredQueue() throws Exception {
        Connection conn1 = this.openWireCf1.createConnection();
        Connection conn2 = this.openWireCf2.createConnection();
        conn1.start();
        conn2.start();
        try {
            Session session1 = conn1.createSession(false, 1);
            Queue targetQueue1 = session1.createQueue(QUEUE_NAME);
            Session session2 = conn2.createSession(false, 1);
            Queue targetQueue2 = session2.createQueue(QUEUE_NAME);
            this.waitForBindings(this.servers[0], QUEUE_NAME, true, 1, 0, 2000L);
            this.waitForBindings(this.servers[1], QUEUE_NAME, true, 1, 0, 2000L);
            this.waitForBindings(this.servers[1], QUEUE_NAME, false, 1, 0, 2000L);
            this.waitForBindings(this.servers[0], QUEUE_NAME, false, 1, 0, 2000L);
            MessageProducer prod1 = session1.createProducer((Destination)targetQueue1);
            MessageConsumer cons2 = session2.createConsumer((Destination)targetQueue2);
            this.waitForBindings(this.servers[0], QUEUE_NAME, false, 1, 1, 2000L);
            this.waitForBindings(this.servers[1], QUEUE_NAME, true, 1, 1, 2000L);
            TextMessage msg = session1.createTextMessage("hello");
            prod1.send((Message)msg);
            Wait.assertTrue(() -> this.getServer(1).locateQueue(SimpleString.toSimpleString((String)QUEUE_NAME)).getMessageCount() == 1L, (long)5000L, (long)100L);
            TextMessage msgReceived = (TextMessage)cons2.receive(5000L);
            TemporaryQueueClusterTest.assertNotNull((Object)msgReceived);
            TemporaryQueueClusterTest.assertEquals((Object)msgReceived.getText(), (Object)msg.getText());
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }
}

