/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Test;

public class GracefulShutdownTest
extends ActiveMQTestBase {
    @Test
    public void testGracefulShutdown() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setGracefulShutdownEnabled(true);
        final ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(true, true);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    server.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        t.setName("shutdown thread");
        t.start();
        while (server.isStarted()) {
            Thread.sleep(100L);
        }
        session.createQueue(new QueueConfiguration("testQueue").setAddress("testAddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = session.createProducer("testAddress");
        producer.send((Message)session.createMessage(true));
        session.start();
        GracefulShutdownTest.assertNotNull((Object)session.createConsumer("testQueue").receive(500L));
        try {
            sf.createSession();
            GracefulShutdownTest.fail((String)"Creating a session here should fail because the acceptors should be paused");
        }
        catch (Exception e) {
            GracefulShutdownTest.assertTrue((boolean)(e instanceof ActiveMQSessionCreationException));
            ActiveMQSessionCreationException activeMQSessionCreationException = (ActiveMQSessionCreationException)e;
            GracefulShutdownTest.assertEquals((Object)activeMQSessionCreationException.getType(), (Object)ActiveMQExceptionType.SESSION_CREATION_REJECTED);
        }
        locator.close();
        long start = System.currentTimeMillis();
        while (t.isAlive()) {
            if (System.currentTimeMillis() - start > 3000L) {
                t.interrupt();
                break;
            }
            Thread.sleep(100L);
        }
        GracefulShutdownTest.assertFalse((boolean)t.isAlive());
    }

    @Test
    public void testGracefulShutdownWithTimeout() throws Exception {
        long timeout = 10000L;
        Configuration config = this.createDefaultInVMConfig().setGracefulShutdownEnabled(true).setGracefulShutdownTimeout(timeout);
        final ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    server.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        t.setName("shutdown thread");
        long start = System.currentTimeMillis();
        t.start();
        while (server.isStarted()) {
            Thread.sleep(100L);
        }
        try {
            sf.createSession();
            GracefulShutdownTest.fail((String)"Creating a session here should fail because the acceptors should be paused");
        }
        catch (Exception e) {
            GracefulShutdownTest.assertTrue((boolean)(e instanceof ActiveMQSessionCreationException));
            ActiveMQSessionCreationException activeMQSessionCreationException = (ActiveMQSessionCreationException)e;
            GracefulShutdownTest.assertEquals((Object)activeMQSessionCreationException.getType(), (Object)ActiveMQExceptionType.SESSION_CREATION_REJECTED);
        }
        Thread.sleep(timeout / 2L);
        GracefulShutdownTest.assertTrue((String)"thread should still be alive here waiting for the timeout to elapse", (boolean)t.isAlive());
        while (t.isAlive()) {
            Thread.sleep(100L);
        }
        GracefulShutdownTest.assertTrue((String)"thread terminated too soon, the graceful shutdown timeout wasn't enforced properly", (System.currentTimeMillis() - start >= timeout ? (byte)1 : 0) != 0);
    }
}

