/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp.util;

import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.apache.activemq.artemis.tests.integration.stomp.util.AbstractStompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionV10;

public class StompClientConnectionV11
extends StompClientConnectionV10 {
    public StompClientConnectionV11(String host, int port) throws IOException {
        super("1.1", host, port);
    }

    public StompClientConnectionV11(String version, String host, int port) throws IOException {
        super(version, host, port);
    }

    public StompClientConnectionV11(URI uri) throws Exception {
        super(uri);
    }

    public StompClientConnectionV11(URI uri, boolean autoConnect) throws Exception {
        super(uri, autoConnect);
    }

    @Override
    public ClientStompFrame connect(String username, String passcode, String clientID) throws IOException, InterruptedException {
        ClientStompFrame response;
        ClientStompFrame frame = this.factory.newFrame("CONNECT");
        frame.addHeader("accept-version", this.getVersion());
        frame.addHeader("host", "localhost");
        if (clientID != null) {
            frame.addHeader("client-id", clientID);
        }
        if (username != null) {
            frame.addHeader("login", username);
            frame.addHeader("passcode", passcode);
        }
        if ("CONNECTED".equals((response = this.sendFrame(frame)).getCommand())) {
            String version = response.getHeader("version");
            if (!version.equals(this.getVersion())) {
                throw new IllegalStateException("incorrect version!");
            }
            this.username = username;
            this.passcode = passcode;
            this.connected = true;
        } else {
            this.connected = false;
        }
        return response;
    }

    public void connect1(String username, String passcode) throws IOException, InterruptedException {
        ClientStompFrame response;
        ClientStompFrame frame = this.factory.newFrame("STOMP");
        frame.addHeader("accept-version", "1.0,1.1");
        frame.addHeader("host", "127.0.0.1");
        if (username != null) {
            frame.addHeader("login", username);
            frame.addHeader("passcode", passcode);
        }
        if ("CONNECTED".equals((response = this.sendFrame(frame)).getCommand())) {
            String version = response.getHeader("version");
            if (!version.equals(this.getVersion())) {
                throw new IllegalStateException("incorrect version!");
            }
            this.username = username;
            this.passcode = passcode;
            this.connected = true;
        } else {
            System.err.println("Connection failed with frame " + response);
            this.connected = false;
        }
    }

    @Override
    public void disconnect() throws IOException, InterruptedException {
        this.stopPinger();
        ClientStompFrame frame = this.factory.newFrame("DISCONNECT");
        String uuid = UUID.randomUUID().toString();
        frame.addHeader("receipt", uuid);
        try {
            ClientStompFrame result;
            if (!(this.transport.isConnected() || (result = this.sendFrame(frame)) != null && "RECEIPT".equals(result.getCommand()) && uuid.equals(result.getHeader("receipt-id")))) {
                throw new IOException("Disconnect failed! " + result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.close();
        this.connected = false;
    }

    @Override
    public ClientStompFrame createFrame(String command) {
        return this.factory.newFrame(command);
    }

    @Override
    public void startPinger(long interval) {
        this.pinger = new AbstractStompClientConnection.Pinger(interval);
        this.pinger.startPing();
    }

    @Override
    public void stopPinger() {
        if (this.pinger != null) {
            this.pinger.stopPing();
            try {
                this.pinger.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.pinger = null;
        }
    }

    @Override
    public int getServerPingNumber() {
        return this.serverPingCounter;
    }
}

