/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.asyncio;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFile;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.unit.core.asyncio.AIOTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MultiThreadAsynchronousFileTest
extends AIOTestBase {
    private static final Logger log = Logger.getLogger(MultiThreadAsynchronousFileTest.class);
    AtomicInteger position = new AtomicInteger(0);
    static final int SIZE = 1024;
    static final int NUMBER_OF_THREADS = 1;
    static final int NUMBER_OF_LINES = 1000;
    ExecutorService executor;
    ExecutorService pollerExecutor;

    @BeforeClass
    public static void hasAIO() {
        Assume.assumeTrue((String)"Test case needs AIO to run", (boolean)AIOSequentialFileFactory.isSupported());
    }

    private static void debug(String msg) {
        log.info((Object)msg);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.pollerExecutor = Executors.newCachedThreadPool((ThreadFactory)new ActiveMQThreadFactory("ActiveMQ-AIO-poller-pool" + System.identityHashCode((Object)this), false, ((Object)((Object)this)).getClass().getClassLoader()));
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.executor.shutdown();
        this.pollerExecutor.shutdown();
        super.tearDown();
    }

    @Test
    public void testMultipleASynchronousWrites() throws Throwable {
        this.executeTest(false);
    }

    @Test
    public void testMultipleSynchronousWrites() throws Throwable {
        this.executeTest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTest(boolean sync) throws Throwable {
        MultiThreadAsynchronousFileTest.debug(sync ? "Sync test:" : "Async test");
        AIOSequentialFileFactory factory = new AIOSequentialFileFactory(this.getTestDirfile(), 100);
        factory.start();
        factory.disableBufferReuse();
        AIOSequentialFile file = (AIOSequentialFile)factory.createSequentialFile(this.fileName);
        file.open();
        try {
            MultiThreadAsynchronousFileTest.debug("Preallocating file");
            file.fill(1024000);
            MultiThreadAsynchronousFileTest.debug("Done Preallocating file");
            CountDownLatch latchStart = new CountDownLatch(2);
            ArrayList<ThreadProducer> list = new ArrayList<ThreadProducer>(1);
            for (int i = 0; i < 1; ++i) {
                ThreadProducer producer = new ThreadProducer("Thread " + i, latchStart, file, sync);
                list.add(producer);
                producer.start();
            }
            latchStart.countDown();
            ActiveMQTestBase.waitForLatch((CountDownLatch)latchStart);
            long startTime = System.currentTimeMillis();
            for (ThreadProducer producer : list) {
                producer.join();
                if (producer.failed == null) continue;
                throw producer.failed;
            }
            long endTime = System.currentTimeMillis();
            MultiThreadAsynchronousFileTest.debug((sync ? "Sync result:" : "Async result:") + " Records/Second = " + 1000000L / (endTime - startTime) + " total time = " + (endTime - startTime) + " total number of records = " + 1000);
        }
        finally {
            file.close();
            factory.stop();
        }
    }

    private static void addString(String str, ByteBuffer buffer) {
        byte[] bytes = str.getBytes();
        buffer.put(bytes);
    }

    private void addData(AIOSequentialFile aio, ByteBuffer buffer, IOCallback callback) throws Exception {
        aio.writeDirect(buffer, true, callback);
    }

    class ThreadProducer
    extends Thread {
        Throwable failed;
        CountDownLatch latchStart;
        boolean sync;
        AIOSequentialFile libaio;

        ThreadProducer(String name, CountDownLatch latchStart, AIOSequentialFile libaio, boolean sync) {
            super(name);
            this.failed = null;
            this.latchStart = latchStart;
            this.libaio = libaio;
            this.sync = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object latchFinishThread;
            super.run();
            ByteBuffer buffer = null;
            buffer = LibaioContext.newAlignedBuffer((int)1024, (int)512);
            try {
                MultiThreadAsynchronousFileTest.addString("Thread name=" + Thread.currentThread().getName() + ";\n", buffer);
                for (int local = buffer.position(); local < buffer.capacity() - 1; ++local) {
                    buffer.put((byte)32);
                }
                buffer.put((byte)10);
                this.latchStart.countDown();
                ActiveMQTestBase.waitForLatch((CountDownLatch)this.latchStart);
                latchFinishThread = null;
                if (!this.sync) {
                    latchFinishThread = new CountDownLatch(1000);
                }
                LinkedList<AIOTestBase.CountDownCallback> list = new LinkedList<AIOTestBase.CountDownCallback>();
                for (int i = 0; i < 1000; ++i) {
                    if (this.sync) {
                        latchFinishThread = new CountDownLatch(1);
                    }
                    AIOTestBase.CountDownCallback callback = new AIOTestBase.CountDownCallback((CountDownLatch)latchFinishThread, null, null, 0);
                    if (!this.sync) {
                        list.add(callback);
                    }
                    MultiThreadAsynchronousFileTest.this.addData(this.libaio, buffer, callback);
                    if (!this.sync) continue;
                    ActiveMQTestBase.waitForLatch((CountDownLatch)latchFinishThread);
                    Assert.assertEquals((long)0L, (long)callback.errorCalled);
                    Assert.assertTrue((boolean)callback.doneCalled);
                }
                if (!this.sync) {
                    ActiveMQTestBase.waitForLatch((CountDownLatch)latchFinishThread);
                }
                for (AIOTestBase.CountDownCallback callback : list) {
                    Assert.assertTrue((boolean)callback.doneCalled);
                    Assert.assertFalse((callback.errorCalled != 0 ? (byte)1 : 0) != 0);
                }
                for (AIOTestBase.CountDownCallback callback : list) {
                    Assert.assertTrue((boolean)callback.doneCalled);
                    Assert.assertFalse((callback.errorCalled != 0 ? (byte)1 : 0) != 0);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.failed = e;
            }
            finally {
                latchFinishThread = MultiThreadAsynchronousFileTest.class;
                synchronized (MultiThreadAsynchronousFileTest.class) {
                    LibaioContext.freeBuffer((ByteBuffer)buffer);
                    // ** MonitorExit[latchFinishThread] (shouldn't be in output)
                }
            }
        }
    }
}

