/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.GeoPointDistanceMultiValuesToSingleValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.AssertionFailure;

public class GeoPointDistanceCollector
implements Collector {
    private static final double MISSING_VALUE_MARKER = Double.NEGATIVE_INFINITY;
    private final GeoPointDistanceMultiValuesToSingleValuesSource valuesSource;
    private final SpatialResultsCollector distances;

    public GeoPointDistanceCollector(String absoluteFieldPath, NestedDocsProvider nestedDocsProvider, GeoPoint center, int hitsCount) {
        this.valuesSource = new GeoPointDistanceMultiValuesToSingleValuesSource(absoluteFieldPath, MultiValueMode.MIN, nestedDocsProvider, center);
        this.distances = new SpatialResultsCollector(hitsCount);
    }

    public Double getDistance(int docId) {
        return this.distances.get(docId);
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return new DistanceLeafCollector(context.docBase, this.createDistanceDocValues(context));
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    private DoubleValues createDistanceDocValues(LeafReaderContext context) throws IOException {
        return this.valuesSource.getValues(context, null);
    }

    private class DistanceLeafCollector
    implements LeafCollector {
        private final int docBase;
        private final DoubleValues distanceDocValues;

        DistanceLeafCollector(int docBase, DoubleValues distanceDocValues) {
            this.docBase = docBase;
            this.distanceDocValues = distanceDocValues;
        }

        public void setScorer(Scorable scorer) {
        }

        public void collect(int docId) throws IOException {
            int absoluteDocId = this.docBase + docId;
            Double distance = null;
            if (this.distanceDocValues.advanceExact(docId)) {
                double distanceFromDocValues = this.distanceDocValues.doubleValue();
                distance = distanceFromDocValues == Double.NEGATIVE_INFINITY ? null : Double.valueOf(distanceFromDocValues);
            }
            GeoPointDistanceCollector.this.distances.put(absoluteDocId, distance);
        }
    }

    private static class SpatialResultsCollector {
        final ArrayList<HitEntry> orderedEntries;
        int currentIterator = 0;

        private SpatialResultsCollector(int size) {
            this.orderedEntries = new ArrayList(size);
        }

        public Double get(int docId) {
            HitEntry currentEntry;
            int startingPoint = this.currentIterator;
            while (this.currentIterator < this.orderedEntries.size() && (currentEntry = this.orderedEntries.get(this.currentIterator)) != null) {
                if (currentEntry.documentId == docId) {
                    return currentEntry.distance;
                }
                ++this.currentIterator;
            }
            this.currentIterator = 0;
            while (this.currentIterator < startingPoint && (currentEntry = this.orderedEntries.get(this.currentIterator)) != null) {
                if (currentEntry.documentId == docId) {
                    return currentEntry.distance;
                }
                ++this.currentIterator;
            }
            throw new AssertionFailure("Unexpected Lucene docId: '%1$s'. No data was collected for this document.");
        }

        void put(int documentId, Double distance) {
            this.orderedEntries.add(new HitEntry(documentId, distance));
        }
    }

    private static class HitEntry {
        private final int documentId;
        private final Double distance;

        private HitEntry(int documentId, Double distance) {
            this.documentId = documentId;
            this.distance = distance;
        }
    }
}

