/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.oob.OOBSession;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.session.SimpleSessionConfig;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DistributableSession
implements io.undertow.server.session.Session {
    private static final Set<String> AUTO_REAUTHENTICATING_MECHANISMS = Set.of("BASIC", "DIGEST", "CLIENT_CERT");
    static final String WEB_SOCKET_CHANNELS_ATTRIBUTE = "io.undertow.websocket.current-connections";
    private static final Set<String> LOCAL_CONTEXT_ATTRIBUTES = Set.of("io.undertow.websocket.current-connections");
    private final UndertowSessionManager manager;
    private final Batch batch;
    private final Consumer<HttpServerExchange> closeTask;
    private final Instant startTime;
    private volatile Map.Entry<Session<Map<String, Object>>, SessionConfig> entry;
    private volatile String id = null;
    private volatile Map<String, Object> localContext = null;

    public DistributableSession(UndertowSessionManager manager, Session<Map<String, Object>> session, SessionConfig config, Batch batch, Consumer<HttpServerExchange> closeTask) {
        this.manager = manager;
        this.id = session.getId();
        this.entry = Map.entry(session, config);
        this.batch = batch;
        this.closeTask = closeTask;
        this.startTime = session.getMetaData().isNew() ? session.getMetaData().getCreationTime() : Instant.now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry<Session<Map<String, Object>>, SessionConfig> getSessionEntry() {
        Map.Entry<Session<Map<String, Object>>, SessionConfig> entry = this.entry;
        if (entry == null) {
            DistributableSession distributableSession = this;
            synchronized (distributableSession) {
                if (this.entry == null) {
                    this.entry = Map.entry(new OOBSession(this.manager.getSessionManager(), this.id, this.localContext), new SimpleSessionConfig(this.id));
                }
                entry = this.entry;
            }
        }
        return entry;
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDone(HttpServerExchange exchange) {
        Session<Map<String, Object>> requestSession = this.getSessionEntry().getKey();
        Batcher batcher = this.manager.getSessionManager().getBatcher();
        try (BatchContext context = batcher.resumeBatch(this.batch);){
            if (this.batch.getState() == Batch.State.DISCARDED) {
                this.batch.close();
            }
            try (Batch batch = this.batch.getState() == Batch.State.CLOSED && requestSession.isValid() ? batcher.createBatch() : this.batch;
                 Session<Map<String, Object>> session = requestSession;){
                if (session.isValid()) {
                    session.getMetaData().setLastAccess(this.startTime, Instant.now());
                }
            }
        }
        catch (Throwable e) {
            UndertowClusteringLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
        }
        finally {
            this.id = requestSession.getId();
            this.localContext = (Map)requestSession.getLocalContext();
            this.entry = null;
            this.closeTask.accept(exchange);
        }
    }

    public String getId() {
        Session<Map<String, Object>> session = this.getSessionEntry().getKey();
        return session.getId();
    }

    public long getCreationTime() {
        long l;
        block8: {
            Session<Map<String, Object>> session = this.getSessionEntry().getKey();
            BatchContext context = this.resumeBatch();
            try {
                l = session.getMetaData().getCreationTime().toEpochMilli();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid(null, session);
                    throw e;
                }
            }
            context.close();
        }
        return l;
    }

    public long getLastAccessedTime() {
        long l;
        block8: {
            Session<Map<String, Object>> session = this.getSessionEntry().getKey();
            BatchContext context = this.resumeBatch();
            try {
                l = session.getMetaData().getLastAccessStartTime().toEpochMilli();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid(null, session);
                    throw e;
                }
            }
            context.close();
        }
        return l;
    }

    public int getMaxInactiveInterval() {
        int n;
        block8: {
            Session<Map<String, Object>> session = this.getSessionEntry().getKey();
            BatchContext context = this.resumeBatch();
            try {
                n = (int)session.getMetaData().getMaxInactiveInterval().getSeconds();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid(null, session);
                    throw e;
                }
            }
            context.close();
        }
        return n;
    }

    public void setMaxInactiveInterval(int interval) {
        Session<Map<String, Object>> session = this.getSessionEntry().getKey();
        try (BatchContext context = this.resumeBatch();){
            session.getMetaData().setMaxInactiveInterval(Duration.ofSeconds(interval));
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    public Set<String> getAttributeNames() {
        Set set;
        block8: {
            Session<Map<String, Object>> session = this.getSessionEntry().getKey();
            BatchContext context = this.resumeBatch();
            try {
                set = session.getAttributes().getAttributeNames();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid(null, session);
                    throw e;
                }
            }
            context.close();
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getAttribute(String name) {
        Session<Map<String, Object>> session = this.getSessionEntry().getKey();
        try (BatchContext context = this.resumeBatch();){
            if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttributes().getAttribute(name);
                AuthenticatedSessionManager.AuthenticatedSession authenticatedSession = auth != null ? auth : ((Map)session.getLocalContext()).get(name);
                return authenticatedSession;
            }
            if (LOCAL_CONTEXT_ATTRIBUTES.contains(name)) {
                Object v = ((Map)session.getLocalContext()).get(name);
                return v;
            }
            Object object = session.getAttributes().getAttribute(name);
            return object;
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        Session<Map<String, Object>> session = this.getSessionEntry().getKey();
        try (BatchContext context = this.resumeBatch();){
            if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)value;
                Object object = AUTO_REAUTHENTICATING_MECHANISMS.contains(auth.getMechanism()) ? ((Map)session.getLocalContext()).put(name, auth) : session.getAttributes().setAttribute(name, (Object)auth);
                return object;
            }
            if (LOCAL_CONTEXT_ATTRIBUTES.contains(name)) {
                Object auth = ((Map)session.getLocalContext()).put(name, value);
                return auth;
            }
            Object old = session.getAttributes().setAttribute(name, value);
            if (old == null) {
                this.manager.getSessionListeners().attributeAdded((io.undertow.server.session.Session)this, name, value);
            } else if (old != value) {
                this.manager.getSessionListeners().attributeUpdated((io.undertow.server.session.Session)this, name, value, old);
            }
            Object object = old;
            return object;
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object removeAttribute(String name) {
        Session<Map<String, Object>> session = this.getSessionEntry().getKey();
        try (BatchContext context = this.resumeBatch();){
            if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttributes().removeAttribute(name);
                AuthenticatedSessionManager.AuthenticatedSession authenticatedSession = auth != null ? auth : ((Map)session.getLocalContext()).remove(name);
                return authenticatedSession;
            }
            if (LOCAL_CONTEXT_ATTRIBUTES.contains(name)) {
                Object auth = ((Map)session.getLocalContext()).remove(name);
                return auth;
            }
            Object old = session.getAttributes().removeAttribute(name);
            if (old != null) {
                this.manager.getSessionListeners().attributeRemoved((io.undertow.server.session.Session)this, name, old);
            }
            Object object = old;
            return object;
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    public void invalidate(HttpServerExchange exchange) {
        Map.Entry<Session<Map<String, Object>>, SessionConfig> entry = this.getSessionEntry();
        Session<Map<String, Object>> session = entry.getKey();
        if (session.isValid()) {
            this.manager.getSessionListeners().sessionDestroyed((io.undertow.server.session.Session)this, exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
            SessionAttributes attributes = session.getAttributes();
            for (String name : attributes.getAttributeNames()) {
                Object value = attributes.getAttribute(name);
                this.manager.getSessionListeners().attributeRemoved((io.undertow.server.session.Session)this, name, value);
            }
        }
        try (BatchContext context = this.resumeBatch();){
            session.invalidate();
            if (exchange != null) {
                String id = session.getId();
                entry.getValue().clearSession(exchange, id);
            }
            if (this.batch != null) {
                this.batch.close();
            }
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
        finally {
            this.closeTask.accept(exchange);
        }
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        if (exchange.isResponseStarted()) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        Session<Map<String, Object>> oldSession = this.getSessionEntry().getKey();
        org.wildfly.clustering.web.session.SessionManager<Map<String, Object>, Batch> manager = this.manager.getSessionManager();
        String id = (String)manager.getIdentifierFactory().get();
        try (BatchContext context = this.resumeBatch();){
            Session newSession = manager.createSession(id);
            try {
                for (String name : oldSession.getAttributes().getAttributeNames()) {
                    newSession.getAttributes().setAttribute(name, oldSession.getAttributes().getAttribute(name));
                }
                newSession.getMetaData().setMaxInactiveInterval(oldSession.getMetaData().getMaxInactiveInterval());
                newSession.getMetaData().setLastAccess(oldSession.getMetaData().getLastAccessStartTime(), oldSession.getMetaData().getLastAccessEndTime());
                ((Map)newSession.getLocalContext()).putAll((Map)oldSession.getLocalContext());
                oldSession.invalidate();
                config.setSessionId(exchange, id);
                this.entry = Map.entry(newSession, config);
            }
            catch (IllegalStateException e) {
                this.closeIfInvalid(exchange, oldSession);
                newSession.invalidate();
                throw e;
            }
        }
        if (!oldSession.isValid()) {
            this.manager.getSessionListeners().sessionIdChanged((io.undertow.server.session.Session)this, oldSession.getId());
        }
        return id;
    }

    private BatchContext resumeBatch() {
        Batch batch = this.batch != null && this.batch.getState() != Batch.State.CLOSED ? this.batch : null;
        return this.manager.getSessionManager().getBatcher().resumeBatch(batch);
    }

    private void closeIfInvalid(HttpServerExchange exchange, Session<Map<String, Object>> session) {
        if (!session.isValid()) {
            try {
                session.close();
            }
            finally {
                this.closeTask.accept(exchange);
            }
        }
    }
}

