/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyResourceDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.web.WebExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class WebSSLDefinition
extends ModelOnlyResourceDefinition {
    protected static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setXmlName("name")).setRequired(false)).build();
    protected static final SimpleAttributeDefinition KEY_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-alias", ModelType.STRING).setRequired(false)).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).build();
    protected static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).build();
    protected static final SimpleAttributeDefinition CERTIFICATE_KEY_FILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-key-file", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition CIPHER_SUITE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cipher-suite", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode("HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5"))).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition VERIFY_CLIENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("verify-client", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition VERIFY_DEPTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("verify-depth", ModelType.INT).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition CERTIFICATE_FILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-file", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition CA_CERTIFICATE_FILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ca-certificate-file", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition CA_CERTIFICATE_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ca-certificate-password", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition CA_REVOCATION_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ca-revocation-url", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition TRUSTSTORE_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("truststore-type", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition KEYSTORE_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("keystore-type", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition SESSION_CACHE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-cache-size", ModelType.INT).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition SESSION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-timeout", ModelType.INT).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static final SimpleAttributeDefinition SSL_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-protocol", ModelType.STRING).setRequired(false)).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    protected static SimpleAttributeDefinition[] SSL_ATTRIBUTES = new SimpleAttributeDefinition[]{KEY_ALIAS, PASSWORD, CERTIFICATE_KEY_FILE, CIPHER_SUITE, PROTOCOL, VERIFY_CLIENT, VERIFY_DEPTH, CERTIFICATE_FILE, CA_CERTIFICATE_FILE, CA_REVOCATION_URL, CA_CERTIFICATE_PASSWORD, KEYSTORE_TYPE, TRUSTSTORE_TYPE, SESSION_CACHE_SIZE, SESSION_TIMEOUT, SSL_PROTOCOL};
    protected static final WebSSLDefinition INSTANCE = new WebSSLDefinition();
    private List<AccessConstraintDefinition> accessConstraints;

    private WebSSLDefinition() {
        super(WebExtension.SSL_PATH, (ResourceDescriptionResolver)WebExtension.getResourceDescriptionResolver("connector.ssl"), (AttributeDefinition[])SSL_ATTRIBUTES);
        SensitivityClassification sc = new SensitivityClassification("web", "web-ssl", false, true, true);
        this.accessConstraints = new SensitiveTargetAccessConstraintDefinition(sc).wrapAsList();
        this.setDeprecated(WebExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration ssl) {
        super.registerAttributes(ssl);
        ssl.registerReadOnlyAttribute((AttributeDefinition)NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }
}

