/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.model.host.AdminOnlyDomainConfigPolicy;
import org.jboss.as.host.controller.operations.DomainControllerWriteAttributeHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.remoting.Protocol;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.security.auth.client.AuthenticationContext;

public class RemoteDomainControllerAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "write-remote-domain-controller";
    public static final SimpleAttributeDefinition PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("port", ModelType.INT).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1, 65535, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setRequires(new String[]{"host"})).build();
    public static final SimpleAttributeDefinition HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setRequires(new String[]{"port"})).build();
    public static final SimpleAttributeDefinition PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)EnumValidator.create(Protocol.class, (Enum[])new Protocol[0]))).setDefaultValue(Protocol.REMOTE.toModelNode())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setRequires(new String[]{"host", "port"})).build();
    public static final SimpleAttributeDefinition AUTHENTICATION_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-context", ModelType.STRING, true).setCapabilityReference("org.wildfly.security.authentication-context", "org.wildfly.host.controller")).setAlternatives(new String[]{"security-realm", "username"})).build();
    public static final SimpleAttributeDefinition USERNAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("username", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM})).setDeprecated(ModelVersion.create((int)5))).build();
    public static final SimpleAttributeDefinition IGNORE_UNUSED_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ignore-unused-configuration", ModelType.BOOLEAN, true).setRequired(false)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM})).build();
    public static final SimpleAttributeDefinition ADMIN_ONLY_POLICY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("admin-only-policy", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM})).setValidator((ParameterValidator)EnumValidator.create(AdminOnlyDomainConfigPolicy.class, (Enum[])new AdminOnlyDomainConfigPolicy[0]))).setAllowedValues(new String[]{AdminOnlyDomainConfigPolicy.ALLOW_NO_CONFIG.toString(), AdminOnlyDomainConfigPolicy.FETCH_FROM_DOMAIN_CONTROLLER.toString(), AdminOnlyDomainConfigPolicy.REQUIRE_LOCAL_CONFIG.toString()})).setDefaultValue(new ModelNode(AdminOnlyDomainConfigPolicy.ALLOW_NO_CONFIG.toString()))).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("write-remote-domain-controller", HostResolver.getResolver("host")).setParameters(new AttributeDefinition[]{PROTOCOL, PORT, HOST, AUTHENTICATION_CONTEXT, USERNAME, IGNORE_UNUSED_CONFIG, ADMIN_ONLY_POLICY}).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.DOMAIN_CONTROLLER).setDeprecated(ModelVersion.create((int)5, (int)0, (int)0)).build();
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final DomainControllerWriteAttributeHandler writeAttributeHandler;

    public RemoteDomainControllerAddHandler(LocalHostControllerInfoImpl hostControllerInfo, DomainControllerWriteAttributeHandler writeAttributeHandler) {
        this.hostControllerInfo = hostControllerInfo;
        this.writeAttributeHandler = writeAttributeHandler;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode current;
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode dc = model.get("domain-controller");
        ModelNode remoteDC = dc.get("remote");
        PROTOCOL.validateAndSet(operation, remoteDC);
        PORT.validateAndSet(operation, remoteDC);
        HOST.validateAndSet(operation, remoteDC);
        USERNAME.validateAndSet(operation, remoteDC);
        IGNORE_UNUSED_CONFIG.validateAndSet(operation, remoteDC);
        ADMIN_ONLY_POLICY.validateAndSet(operation, remoteDC);
        if (remoteDC.hasDefined(ADMIN_ONLY_POLICY.getName()) && (current = ADMIN_ONLY_POLICY.resolveModelAttribute(context, remoteDC)).asString().equals(AdminOnlyDomainConfigPolicy.LEGACY_FETCH_FROM_DOMAIN_CONTROLLER.toString())) {
            ControllerLogger.ROOT_LOGGER.adminOnlyPolicyDeprecatedValue();
            remoteDC.get(ADMIN_ONLY_POLICY.getName()).set(AdminOnlyDomainConfigPolicy.FETCH_FROM_DOMAIN_CONTROLLER.toString());
        }
        if (operation.has(AUTHENTICATION_CONTEXT.getName())) {
            AUTHENTICATION_CONTEXT.validateAndSet(operation, remoteDC);
            final String authenticationContext = AUTHENTICATION_CONTEXT.resolveModelAttribute(context, operation).asString();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    RemoteDomainControllerAddHandler.this.hostControllerInfo.setAuthenticationContext(context.getCapabilityServiceName("org.wildfly.security.authentication-context", authenticationContext, AuthenticationContext.class));
                }
            }, OperationContext.Stage.RUNTIME);
        } else {
            remoteDC.get(AUTHENTICATION_CONTEXT.getName()).clear();
        }
        if (dc.has("local")) {
            dc.remove("local");
        }
        if (context.isBooting()) {
            this.writeAttributeHandler.initializeRemoteDomain(context, remoteDC);
        } else {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!context.isBooting()) {
                    context.revertReloadRequired();
                }
            }
        });
    }
}

