/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.File;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.notification.NotificationFilter;
import org.jboss.as.controller.notification.NotificationHandler;
import org.jboss.as.controller.notification.NotificationHandlerRegistry;
import org.jboss.as.controller.registry.NotificationHandlerRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.scanner.DefaultDeploymentOperations;
import org.jboss.as.server.deployment.scanner.DeploymentScannerDefinition;
import org.jboss.as.server.deployment.scanner.FileSystemDeploymentService;
import org.jboss.as.server.deployment.scanner.api.DeploymentOperations;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class DeploymentScannerService
implements org.jboss.msc.service.Service<DeploymentScanner> {
    private final PathAddress resourceAddress;
    private final long interval;
    private TimeUnit unit = TimeUnit.MILLISECONDS;
    private final boolean enabled;
    private final boolean autoDeployZipped;
    private final boolean autoDeployExploded;
    private final boolean autoDeployXml;
    private final long deploymentTimeout;
    private final String relativeTo;
    private final String path;
    private final boolean rollbackOnRuntimeFailure;
    private static final NotificationFilter DEPLOYMENT_FILTER = notification -> {
        if ("deployment-undeployed".equals(notification.getType()) || "deployment-deployed".equals(notification.getType())) {
            List properties;
            ModelNode notificationData = notification.getData();
            if (notificationData.hasDefined("server-booting") && notificationData.get("server-booting").asBoolean()) {
                return false;
            }
            if (notificationData.hasDefined("owner") && (properties = notificationData.get("owner").asPropertyList()).size() >= 2) {
                return !"deployment-scanner".equals(((Property)properties.get(0)).getValue().asString()) && !"scanner".equals(((Property)properties.get(1)).getName());
            }
            return true;
        }
        return false;
    };
    private FileSystemDeploymentService scanner;
    private final Consumer<DeploymentScanner> serviceConsumer;
    private final Supplier<PathManager> pathManager;
    private final Supplier<NotificationHandlerRegistry> notificationRegistry;
    private final Supplier<ModelControllerClientFactory> clientFactory;
    private final Supplier<ProcessStateNotifier> processStateNotifier;
    private final ScheduledExecutorService scheduledExecutor;
    private volatile PathManager.Callback.Handle callbackHandle;

    public static ServiceName getServiceName(String repositoryName) {
        return DeploymentScannerDefinition.SCANNER_CAPABILITY.getCapabilityServiceName(new String[]{repositoryName});
    }

    public static void addService(OperationContext context, PathAddress resourceAddress, String relativeTo, String path, int scanInterval, TimeUnit unit, boolean autoDeployZip, boolean autoDeployExploded, boolean autoDeployXml, boolean scanEnabled, long deploymentTimeout, boolean rollbackOnRuntimeFailure, FileSystemDeploymentService bootTimeService, ScheduledExecutorService scheduledExecutorService) {
        RuntimeCapability capName = DeploymentScannerDefinition.SCANNER_CAPABILITY.fromBaseCapability(resourceAddress.getLastElement().getValue());
        CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(capName);
        Consumer serviceConsumer = sb.provides(new RuntimeCapability[]{capName});
        Supplier pathManager = sb.requiresCapability("org.wildfly.management.path-manager", PathManager.class, new String[0]);
        Supplier notificationRegistry = sb.requiresCapability("org.wildfly.management.notification-handler-registry", NotificationHandlerRegistry.class, new String[0]);
        Supplier clientFactory = sb.requiresCapability("org.wildfly.management.model-controller-client-factory", ModelControllerClientFactory.class, new String[0]);
        Supplier processStateNotifier = sb.requiresCapability("org.wildfly.management.process-state-notifier", ProcessStateNotifier.class, new String[0]);
        sb.requires(Services.JBOSS_DEPLOYMENT_CHAINS);
        DeploymentScannerService service = new DeploymentScannerService(serviceConsumer, pathManager, notificationRegistry, clientFactory, processStateNotifier, scheduledExecutorService, resourceAddress, relativeTo, path, scanInterval, unit, autoDeployZip, autoDeployExploded, autoDeployXml, scanEnabled, deploymentTimeout, rollbackOnRuntimeFailure, bootTimeService);
        sb.setInstance((Service)service);
        sb.install();
    }

    private DeploymentScannerService(Consumer<DeploymentScanner> serviceConsumer, Supplier<PathManager> pathManager, Supplier<NotificationHandlerRegistry> notificationRegistry, Supplier<ModelControllerClientFactory> clientFactory, Supplier<ProcessStateNotifier> processStateNotifier, ScheduledExecutorService scheduledExecutor, PathAddress resourceAddress, String relativeTo, String path, int interval, TimeUnit unit, boolean autoDeployZipped, boolean autoDeployExploded, boolean autoDeployXml, boolean enabled, long deploymentTimeout, boolean rollbackOnRuntimeFailure, FileSystemDeploymentService bootTimeService) {
        this.serviceConsumer = serviceConsumer;
        this.pathManager = pathManager;
        this.notificationRegistry = notificationRegistry;
        this.clientFactory = clientFactory;
        this.scheduledExecutor = scheduledExecutor;
        this.processStateNotifier = processStateNotifier;
        this.resourceAddress = resourceAddress;
        this.relativeTo = relativeTo;
        this.path = path;
        this.interval = interval;
        this.unit = unit;
        this.autoDeployZipped = autoDeployZipped;
        this.autoDeployExploded = autoDeployExploded;
        this.autoDeployXml = autoDeployXml;
        this.enabled = enabled;
        this.rollbackOnRuntimeFailure = rollbackOnRuntimeFailure;
        this.deploymentTimeout = deploymentTimeout;
        this.scanner = bootTimeService;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            DeploymentOperations.Factory factory = new DeploymentOperations.Factory(){

                @Override
                public DeploymentOperations create() {
                    return new DefaultDeploymentOperations(DeploymentScannerService.this.clientFactory.get(), DeploymentScannerService.this.scheduledExecutor);
                }
            };
            if (this.scanner == null) {
                PathManager pathManager = this.pathManager.get();
                String pathName = pathManager.resolveRelativePathEntry(this.path, this.relativeTo);
                File relativePath = null;
                if (this.relativeTo != null) {
                    relativePath = new File(pathManager.getPathEntry(this.relativeTo).resolvePath());
                    this.callbackHandle = pathManager.registerCallback(pathName, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
                }
                FileSystemDeploymentService scanner = new FileSystemDeploymentService(this.resourceAddress, this.relativeTo, new File(pathName), relativePath, factory, this.scheduledExecutor);
                scanner.setScanInterval(this.unit.toMillis(this.interval));
                scanner.setAutoDeployExplodedContent(this.autoDeployExploded);
                scanner.setAutoDeployZippedContent(this.autoDeployZipped);
                scanner.setAutoDeployXMLContent(this.autoDeployXml);
                scanner.setRuntimeFailureCausesRollback(this.rollbackOnRuntimeFailure);
                scanner.setDeploymentTimeout(this.deploymentTimeout);
                this.scanner = scanner;
            } else {
                this.scanner.setDeploymentOperationsFactory(factory);
            }
            this.scanner.setProcessStateNotifier(this.processStateNotifier.get());
            this.notificationRegistry.get().registerNotificationHandler(NotificationHandlerRegistration.ANY_ADDRESS, (NotificationHandler)this.scanner, DEPLOYMENT_FILTER);
            if (this.enabled) {
                this.scanner.startScanner();
            }
            this.serviceConsumer.accept(this.scanner);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.serviceConsumer.accept(null);
        FileSystemDeploymentService scanner = this.scanner;
        this.notificationRegistry.get().unregisterNotificationHandler(NotificationHandlerRegistration.ANY_ADDRESS, (NotificationHandler)this.scanner, DEPLOYMENT_FILTER);
        this.scanner = null;
        scanner.stopScanner();
        this.scheduledExecutor.shutdown();
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
    }

    public synchronized DeploymentScanner getValue() throws IllegalStateException {
        FileSystemDeploymentService scanner = this.scanner;
        if (scanner == null) {
            throw new IllegalStateException();
        }
        return scanner;
    }
}

