/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.path.impl;

import java.util.BitSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathFilterImpl;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathOrdinals;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathsDefinition;
import org.hibernate.search.util.common.impl.CollectionHelper;

public final class PojoPathFilterProvider {
    private final PojoPathOrdinals ordinals;
    private final PojoPathsDefinition definitions;

    public PojoPathFilterProvider(PojoPathOrdinals ordinals, PojoPathsDefinition definitions) {
        this.ordinals = ordinals;
        this.definitions = definitions;
        for (String path : definitions.preDefinedOrdinals()) {
            ordinals.toExistingOrNewOrdinal(path);
        }
    }

    public PojoPathFilter create(Set<PojoModelPathValueNode> paths) {
        LinkedHashSet pathsAsStrings = CollectionHelper.newLinkedHashSet((int)paths.size());
        this.definitions.interpretPaths(pathsAsStrings, paths);
        BitSet acceptedPaths = new BitSet();
        for (String pathsAsString : pathsAsStrings) {
            acceptedPaths.set(this.ordinals.toExistingOrNewOrdinal(pathsAsString));
        }
        return new PojoPathFilterImpl(this.ordinals, acceptedPaths);
    }
}

