/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Test;

public class JMSMessageTypesTest
extends JMSClientTestSupport {
    final int NUM_MESSAGES = 10;

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAddressControlSendMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        this.server.createQueue(new QueueConfiguration(address).setRoutingType(RoutingType.ANYCAST));
        AddressControl addressControl = ManagementControlHelper.createAddressControl(address, this.mBeanServer);
        Assert.assertEquals((long)1L, (long)addressControl.getQueueNames().length);
        addressControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, this.fullUser, this.fullPass);
        Wait.assertEquals((long)1L, () -> ((AddressControl)addressControl).getMessageCount());
        try (Connection connection = this.createConnection("myClientId");){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(address.toString());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(5000L);
            JMSMessageTypesTest.assertNotNull((Object)message);
            byte[] buffer = new byte[(int)((BytesMessage)message).getBodyLength()];
            ((BytesMessage)message).readBytes(buffer);
            JMSMessageTypesTest.assertEquals((Object)"test", (Object)new String(buffer));
            session.close();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAddressControlSendMessageWithText() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        this.server.createQueue(new QueueConfiguration(address).setRoutingType(RoutingType.ANYCAST));
        AddressControl addressControl = ManagementControlHelper.createAddressControl(address, this.mBeanServer);
        Assert.assertEquals((long)1L, (long)addressControl.getQueueNames().length);
        addressControl.sendMessage(null, 3, "test", false, this.fullUser, this.fullPass);
        Wait.assertEquals((long)1L, () -> ((AddressControl)addressControl).getMessageCount());
        Assert.assertEquals((long)1L, (long)addressControl.getMessageCount());
        try (Connection connection = this.createConnection("myClientId");){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(address.toString());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(500L);
            JMSMessageTypesTest.assertNotNull((Object)message);
            String text = ((TextMessage)message).getText();
            JMSMessageTypesTest.assertEquals((Object)"test", (Object)text);
            session.close();
            connection.close();
        }
    }

    private void testBytesMessageSendReceive(Connection producerConnection, Connection consumerConnection) throws Throwable {
        long time = System.currentTimeMillis();
        Session session = producerConnection.createSession(false, 1);
        Queue queue = session.createQueue(this.getQueueName());
        byte[] bytes = new byte[16];
        for (int i = 0; i <= 15; ++i) {
            bytes[i] = (byte)i;
        }
        MessageProducer producer = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            this.instanceLog.debug((Object)("Sending " + i));
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(bytes);
            message.setIntProperty("count", i);
            producer.send((Message)message);
        }
        Session sessionConsumer = consumerConnection.createSession(false, 1);
        Queue consumerQueue = sessionConsumer.createQueue(this.getQueueName());
        MessageConsumer consumer = sessionConsumer.createConsumer((Destination)consumerQueue);
        for (int i = 0; i < 10; ++i) {
            BytesMessage m = (BytesMessage)consumer.receive(5000L);
            Assert.assertNotNull((String)("Could not receive message count=" + i + " on consumer"), (Object)m);
            m.reset();
            long size = m.getBodyLength();
            byte[] bytesReceived = new byte[(int)size];
            m.readBytes(bytesReceived);
            this.instanceLog.debug((Object)("Received " + ByteUtil.bytesToHex((byte[])bytesReceived, (int)1) + " count - " + m.getIntProperty("count")));
            Assert.assertArrayEquals((byte[])bytes, (byte[])bytesReceived);
        }
        long taken = (System.currentTimeMillis() - time) / 1000L;
        this.instanceLog.debug((Object)("taken = " + taken));
    }

    @Test(timeout=60000L)
    public void testBytesMessageSendReceiveFromAMQPToAMQP() throws Throwable {
        this.testBytesMessageSendReceive(this.createConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testBytesMessageSendReceiveFromCoreToAMQP() throws Throwable {
        this.testBytesMessageSendReceive(this.createCoreConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testBytesMessageSendReceiveFromAMQPToCore() throws Throwable {
        this.testBytesMessageSendReceive(this.createConnection(), this.createCoreConnection());
    }

    private void testMessageSendReceive(Connection producerConnection, Connection consumerConnection) throws Throwable {
        long time = System.currentTimeMillis();
        Session session = producerConnection.createSession(false, 1);
        Queue queue = session.createQueue(this.getQueueName());
        byte[] bytes = new byte[16];
        for (int i = 0; i <= 15; ++i) {
            bytes[i] = (byte)i;
        }
        MessageProducer producer = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            this.instanceLog.debug((Object)("Sending " + i));
            Message message = session.createMessage();
            message.setIntProperty("count", i);
            producer.send(message);
        }
        Session sessionConsumer = consumerConnection.createSession(false, 1);
        Queue consumerQueue = sessionConsumer.createQueue(this.getQueueName());
        MessageConsumer consumer = sessionConsumer.createConsumer((Destination)consumerQueue);
        for (int i = 0; i < 10; ++i) {
            Message m = consumer.receive(5000L);
            Assert.assertNotNull((String)("Could not receive message count=" + i + " on consumer"), (Object)m);
        }
        long taken = (System.currentTimeMillis() - time) / 1000L;
        this.instanceLog.debug((Object)("taken = " + taken));
    }

    @Test(timeout=60000L)
    public void testMessageSendReceiveFromAMQPToAMQP() throws Throwable {
        this.testMessageSendReceive(this.createConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testMessageSendReceiveFromCoreToAMQP() throws Throwable {
        this.testMessageSendReceive(this.createCoreConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testMessageSendReceiveFromAMQPToCore() throws Throwable {
        this.testMessageSendReceive(this.createConnection(), this.createCoreConnection());
    }

    private void testMapMessageSendReceive(Connection producerConnection, Connection consumerConnection) throws Throwable {
        long time = System.currentTimeMillis();
        Session session = producerConnection.createSession(false, 1);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            this.instanceLog.debug((Object)("Sending " + i));
            MapMessage message = session.createMapMessage();
            message.setInt("i", i);
            message.setIntProperty("count", i);
            producer.send((Message)message);
        }
        Session sessionConsumer = consumerConnection.createSession(false, 1);
        Queue consumerQueue = sessionConsumer.createQueue(this.getQueueName());
        MessageConsumer consumer = sessionConsumer.createConsumer((Destination)consumerQueue);
        for (int i = 0; i < 10; ++i) {
            MapMessage m = (MapMessage)consumer.receive(5000L);
            Assert.assertNotNull((String)("Could not receive message count=" + i + " on consumer"), (Object)m);
            Assert.assertEquals((long)i, (long)m.getInt("i"));
            Assert.assertEquals((long)i, (long)m.getIntProperty("count"));
        }
        long taken = (System.currentTimeMillis() - time) / 1000L;
        this.instanceLog.debug((Object)("taken = " + taken));
    }

    @Test(timeout=60000L)
    public void testMapMessageSendReceiveFromAMQPToAMQP() throws Throwable {
        this.testMapMessageSendReceive(this.createConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testMapMessageSendReceiveFromCoreToAMQP() throws Throwable {
        this.testMapMessageSendReceive(this.createCoreConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testMapMessageSendReceiveFromAMQPToCore() throws Throwable {
        this.testMapMessageSendReceive(this.createConnection(), this.createCoreConnection());
    }

    private void testTextMessageSendReceive(Connection producerConnection, Connection consumerConnection) throws Throwable {
        long time = System.currentTimeMillis();
        Session session = producerConnection.createSession(false, 1);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            this.instanceLog.debug((Object)("Sending " + i));
            TextMessage message = session.createTextMessage("text" + i);
            message.setStringProperty("text", "text" + i);
            producer.send((Message)message);
        }
        Session sessionConsumer = consumerConnection.createSession(false, 1);
        Queue consumerQueue = sessionConsumer.createQueue(this.getQueueName());
        MessageConsumer consumer = sessionConsumer.createConsumer((Destination)consumerQueue);
        for (int i = 0; i < 10; ++i) {
            TextMessage m = (TextMessage)consumer.receive(5000L);
            Assert.assertNotNull((String)("Could not receive message count=" + i + " on consumer"), (Object)m);
            Assert.assertEquals((Object)("text" + i), (Object)m.getText());
        }
        long taken = (System.currentTimeMillis() - time) / 1000L;
        this.instanceLog.debug((Object)("taken = " + taken));
    }

    @Test(timeout=60000L)
    public void testTextMessageSendReceiveFromAMQPToAMQP() throws Throwable {
        this.testTextMessageSendReceive(this.createConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testTextMessageSendReceiveFromCoreToAMQP() throws Throwable {
        this.testTextMessageSendReceive(this.createCoreConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testTextMessageSendReceiveFromAMQPToCore() throws Throwable {
        this.testTextMessageSendReceive(this.createConnection(), this.createCoreConnection());
    }

    private void testStreamMessageSendReceive(Connection producerConnection, Connection consumerConnection) throws Throwable {
        Session session = producerConnection.createSession(false, 1);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            StreamMessage message = session.createStreamMessage();
            message.writeInt(i);
            message.writeBoolean(true);
            message.writeString("test");
            producer.send((Message)message);
        }
        Session sessionConsumer = consumerConnection.createSession(false, 1);
        Queue consumerQueue = sessionConsumer.createQueue(this.getQueueName());
        MessageConsumer consumer = sessionConsumer.createConsumer((Destination)consumerQueue);
        for (int i = 0; i < 10; ++i) {
            StreamMessage m = (StreamMessage)consumer.receive(5000L);
            Assert.assertNotNull((String)("Could not receive message count=" + i + " on consumer"), (Object)m);
            Assert.assertEquals((long)i, (long)m.readInt());
            Assert.assertEquals((Object)true, (Object)m.readBoolean());
            Assert.assertEquals((Object)"test", (Object)m.readString());
        }
    }

    @Test(timeout=60000L)
    public void testStreamMessageSendReceiveFromAMQPToAMQP() throws Throwable {
        this.testStreamMessageSendReceive(this.createConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testStreamMessageSendReceiveFromCoreToAMQP() throws Throwable {
        this.testStreamMessageSendReceive(this.createCoreConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testStreamMessageSendReceiveFromAMQPToCore() throws Throwable {
        this.testStreamMessageSendReceive(this.createConnection(), this.createCoreConnection());
    }

    private void testObjectMessageWithArrayListPayload(Connection producerConnection, Connection consumerConnection) throws Throwable {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("aString");
        Session session = producerConnection.createSession(false, 1);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        ObjectMessage objectMessage = session.createObjectMessage(payload);
        producer.send((Message)objectMessage);
        session.close();
        session = consumerConnection.createSession(false, 1);
        Queue consumerQueue = session.createQueue(this.getQueueName());
        MessageConsumer cons = session.createConsumer((Destination)consumerQueue);
        consumerConnection.start();
        objectMessage = (ObjectMessage)cons.receive(5000L);
        JMSMessageTypesTest.assertNotNull((Object)objectMessage);
        ArrayList received = (ArrayList)objectMessage.getObject();
        JMSMessageTypesTest.assertEquals(received.get(0), (Object)"aString");
        consumerConnection.close();
    }

    @Test(timeout=60000L)
    public void testObjectMessageWithArrayListPayloadFromAMQPToAMQP() throws Throwable {
        this.testObjectMessageWithArrayListPayload(this.createConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testObjectMessageWithArrayListPayloadFromCoreToAMQP() throws Throwable {
        this.testObjectMessageWithArrayListPayload(this.createCoreConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testObjectMessageWithArrayListPayloadFromAMQPToCore() throws Throwable {
        this.testObjectMessageWithArrayListPayload(this.createConnection(), this.createCoreConnection());
    }

    private void testObjectMessageUsingCustomType(Connection producerConnection, Connection consumerConnection) throws Throwable {
        long time = System.currentTimeMillis();
        Session session = producerConnection.createSession(false, 1);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            this.instanceLog.debug((Object)("Sending " + i));
            ObjectMessage message = session.createObjectMessage((Serializable)new AnythingSerializable(i));
            producer.send((Message)message);
        }
        Session sessionConsumer = consumerConnection.createSession(false, 1);
        Queue consumerQueue = sessionConsumer.createQueue(this.getQueueName());
        MessageConsumer consumer = sessionConsumer.createConsumer((Destination)consumerQueue);
        for (int i = 0; i < 10; ++i) {
            ObjectMessage msg = (ObjectMessage)consumer.receive(5000L);
            Assert.assertNotNull((String)("Could not receive message count=" + i + " on consumer"), (Object)msg);
            AnythingSerializable someSerialThing = (AnythingSerializable)msg.getObject();
            Assert.assertEquals((long)i, (long)someSerialThing.getCount());
        }
        long taken = (System.currentTimeMillis() - time) / 1000L;
        this.instanceLog.debug((Object)("taken = " + taken));
    }

    @Test(timeout=60000L)
    public void testObjectMessageUsingCustomTypeFromAMQPToAMQP() throws Throwable {
        this.testObjectMessageUsingCustomType(this.createConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testObjectMessageUsingCustomTypeFromCoreToAMQP() throws Throwable {
        this.testObjectMessageUsingCustomType(this.createCoreConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testObjectMessageUsingCustomTypeFromAMQPToCore() throws Throwable {
        this.testObjectMessageUsingCustomType(this.createConnection(), this.createCoreConnection());
    }

    private void testPropertiesArePreserved(Connection producerConnection, Connection consumerConnection) throws Exception {
        Session session = producerConnection.createSession(false, 1);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage();
        message.setText("msg:0");
        message.setBooleanProperty("true", true);
        message.setBooleanProperty("false", false);
        message.setStringProperty("foo", "bar");
        message.setDoubleProperty("double", 66.6);
        message.setFloatProperty("float", 56.789f);
        message.setIntProperty("int", 8);
        message.setByteProperty("byte", (byte)10);
        producer.send((Message)message);
        producer.send((Message)message);
        consumerConnection.start();
        Session consumerSession = consumerConnection.createSession(false, 1);
        Queue consumerQueue = consumerSession.createQueue(this.getQueueName());
        MessageConsumer messageConsumer = consumerSession.createConsumer((Destination)consumerQueue);
        TextMessage received = (TextMessage)messageConsumer.receive(5000L);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)"msg:0", (Object)received.getText());
        Assert.assertEquals((Object)received.getBooleanProperty("true"), (Object)true);
        Assert.assertEquals((Object)received.getBooleanProperty("false"), (Object)false);
        Assert.assertEquals((Object)received.getStringProperty("foo"), (Object)"bar");
        Assert.assertEquals((double)received.getDoubleProperty("double"), (double)66.6, (double)1.0E-4);
        Assert.assertEquals((double)received.getFloatProperty("float"), (double)56.789f, (double)1.0E-4);
        Assert.assertEquals((long)received.getIntProperty("int"), (long)8L);
        Assert.assertEquals((long)received.getByteProperty("byte"), (long)10L);
        received = (TextMessage)messageConsumer.receive(5000L);
        Assert.assertNotNull((Object)received);
        consumerConnection.close();
    }

    @Test(timeout=60000L)
    public void testPropertiesArePreservedFromAMQPToAMQP() throws Throwable {
        this.testPropertiesArePreserved(this.createConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testPropertiesArePreservedFromCoreToAMQP() throws Throwable {
        this.testPropertiesArePreserved(this.createCoreConnection(), this.createConnection());
    }

    @Test(timeout=60000L)
    public void testPropertiesArePreservedFromAMQPToCore() throws Throwable {
        this.testPropertiesArePreserved(this.createConnection(), this.createCoreConnection());
    }

    public static class AnythingSerializable
    implements Serializable {
        private static final long serialVersionUID = 5972085029690947807L;
        private int count;

        public AnythingSerializable(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

