/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.commons.io.FileUtils;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.server.ldap.handlers.sasl.gssapi.GssapiMechanismHandler;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="Example", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\ndc: example\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})}, additionalInterceptors={KeyDerivationInterceptor.class})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=1024)}, saslHost="localhost", saslPrincipal="ldap/localhost@EXAMPLE.COM", saslMechanisms={@SaslMechanism(name="GSSAPI", implClass=GssapiMechanismHandler.class)})
@CreateKdcServer(transports={@CreateTransport(protocol="TCP", port=0)})
@ApplyLdifFiles(value={"SaslKrb5LDAPSecurityTest.ldif"})
public class SaslKrb5LDAPSecurityTest
extends AbstractLdapTestUnit {
    protected static final Logger LOG;
    public static final String QUEUE_NAME = "some_queue";
    ActiveMQServer server;
    public static final String TARGET_TMP = "./target/tmp";
    private static final String PRINCIPAL = "uid=admin,ou=system";
    private static final String CREDENTIALS = "secret";
    private final boolean debug = false;
    @Rule
    public TemporaryFolder temporaryFolder;
    private String testDir;

    public SaslKrb5LDAPSecurityTest() {
        File parent = new File(TARGET_TMP);
        parent.mkdirs();
        this.temporaryFolder = new TemporaryFolder(parent);
    }

    @Before
    public void setUp() throws Exception {
        this.testDir = this.temporaryFolder.getRoot().getAbsolutePath();
        File userKeyTab = new File("target/test.krb5.keytab");
        this.createPrincipal(userKeyTab, "client", "amqp/localhost", "ldap/localhost");
        this.rewriteKerb5Conf();
    }

    private void createArtemisServer(String securityConfigScope) {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(securityConfigScope);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("port", String.valueOf(5672));
        params.put("protocols", "AMQP");
        HashMap<String, String> amqpParams = new HashMap<String, String>();
        amqpParams.put("saslMechanisms", "GSSAPI");
        amqpParams.put("saslLoginConfigScope", "amqp-sasl-gssapi");
        ConfigurationImpl configuration = new ConfigurationImpl().setSecurityEnabled(true).addAcceptorConfiguration(new TransportConfiguration(ActiveMQTestBase.NETTY_ACCEPTOR_FACTORY, params, "netty-amqp", amqpParams)).setJournalDirectory(ActiveMQTestBase.getJournalDir((String)this.testDir, (int)0, (boolean)false)).setBindingsDirectory(ActiveMQTestBase.getBindingsDir((String)this.testDir, (int)0, (boolean)false)).setPagingDirectory(ActiveMQTestBase.getPageDir((String)this.testDir, (int)0, (boolean)false)).setLargeMessagesDirectory(ActiveMQTestBase.getLargeMessagesDir((String)this.testDir, (int)0, (boolean)false));
        this.server = ActiveMQServers.newActiveMQServer((Configuration)configuration, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false);
    }

    private void rewriteKerb5Conf() throws Exception {
        StringBuilder sb = new StringBuilder();
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("minikdc-krb5.conf");
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("{3}");
                line = reader.readLine();
            }
        }
        InetSocketAddress addr = (InetSocketAddress)kdcServer.getTransports()[0].getAcceptor().getLocalAddress();
        int port = addr.getPort();
        File krb5conf = new File(this.testDir, "krb5.conf").getAbsoluteFile();
        String krb5confBody = MessageFormat.format(sb.toString(), this.getRealm(), "localhost", Integer.toString(port), System.getProperty("line.separator"));
        FileUtils.writeStringToFile((File)krb5conf, (String)krb5confBody, (Charset)StandardCharsets.UTF_8);
        System.setProperty("java.security.krb5.conf", krb5conf.getAbsolutePath());
        System.setProperty("sun.security.krb5.debug", "true");
        Class<?> classRef = System.getProperty("java.vendor").contains("IBM") ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
        Method refreshMethod = classRef.getMethod("refresh", new Class[0]);
        refreshMethod.invoke(classRef, new Object[0]);
        LOG.debug("krb5.conf to: {}", (Object)krb5conf.getAbsolutePath());
    }

    private void dumpLdapContents() throws Exception {
        String ss;
        Entry entry;
        EntryFilteringCursor cursor = (EntryFilteringCursor)SaslKrb5LDAPSecurityTest.getService().getAdminSession().search(new Dn(new String[]{"ou=system"}), SearchScope.SUBTREE, (ExprNode)new PresenceNode("ObjectClass"), AliasDerefMode.DEREF_ALWAYS, new String[0]);
        String st = "";
        while (cursor.next()) {
            entry = (Entry)cursor.get();
            ss = LdifUtils.convertToLdif((Entry)entry);
            st = st + ss + "\n";
        }
        LOG.debug(st);
        cursor = (EntryFilteringCursor)SaslKrb5LDAPSecurityTest.getService().getAdminSession().search(new Dn(new String[]{"dc=example,dc=com"}), SearchScope.SUBTREE, (ExprNode)new PresenceNode("ObjectClass"), AliasDerefMode.DEREF_ALWAYS, new String[0]);
        st = "";
        while (cursor.next()) {
            entry = (Entry)cursor.get();
            ss = LdifUtils.convertToLdif((Entry)entry);
            st = st + ss + "\n";
        }
        LOG.debug(st);
    }

    private void initLogging() {
        for (java.util.logging.Logger logger2 : new java.util.logging.Logger[]{java.util.logging.Logger.getLogger("logincontext"), java.util.logging.Logger.getLogger("javax.security.sasl"), java.util.logging.Logger.getLogger("org.apache.qpid.proton")}) {
            logger2.setLevel(Level.FINEST);
            logger2.addHandler(new ConsoleHandler());
            for (Handler handler : logger2.getHandlers()) {
                handler.setLevel(Level.FINEST);
            }
        }
    }

    public synchronized void createPrincipal(String principal, String password) throws Exception {
        String baseDn = SaslKrb5LDAPSecurityTest.getKdcServer().getSearchBaseDn();
        String content = "dn: uid=" + principal + "," + baseDn + "\nobjectClass: top\nobjectClass: person\nobjectClass: inetOrgPerson\nobjectClass: krb5principal\nobjectClass: krb5kdcentry\ncn: " + principal + "\nsn: " + principal + "\nuid: " + principal + "\nuserPassword: " + password + "\nbusinessCategory: cn=admins,ou=system\nbusinessCategory: cn=bees,ou=system\nkrb5PrincipalName: " + principal + "@" + this.getRealm() + "\nkrb5KeyVersionNumber: 0";
        try (LdifReader ldifReader = new LdifReader((Reader)new StringReader(content));){
            for (LdifEntry ldifEntry : ldifReader) {
                service.getAdminSession().add((Entry)new DefaultEntry(service.getSchemaManager(), ldifEntry.getEntry()));
            }
        }
    }

    public void createPrincipal(File keytabFile, String ... principals) throws Exception {
        String generatedPassword = "notSecret!";
        Keytab keytab = new Keytab();
        ArrayList<KeytabEntry> entries = new ArrayList<KeytabEntry>();
        for (String principal : principals) {
            this.createPrincipal(principal, generatedPassword);
            principal = principal + "@" + this.getRealm();
            KerberosTime timestamp = new KerberosTime();
            for (Map.Entry entry : KerberosKeyFactory.getKerberosKeys((String)principal, (String)generatedPassword).entrySet()) {
                EncryptionKey ekey = (EncryptionKey)entry.getValue();
                byte keyVersion = (byte)ekey.getKeyVersion();
                entries.add(new KeytabEntry(principal, 1, timestamp, keyVersion, ekey));
            }
        }
        keytab.setEntries(entries);
        keytab.write(keytabFile);
    }

    private String getRealm() {
        return SaslKrb5LDAPSecurityTest.getKdcServer().getConfig().getPrimaryRealm();
    }

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testRunning() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:1024");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", PRINCIPAL);
        env.put("java.naming.security.credentials", CREDENTIALS);
        InitialDirContext ctx = new InitialDirContext(env);
        HashSet<String> set = new HashSet<String>();
        NamingEnumeration<NameClassPair> list = ctx.list("ou=system");
        while (list.hasMore()) {
            NameClassPair ncp = list.next();
            set.add(ncp.getName());
        }
        Assert.assertTrue((boolean)set.contains("uid=admin"));
        Assert.assertTrue((boolean)set.contains("ou=users"));
        Assert.assertTrue((boolean)set.contains("ou=groups"));
        Assert.assertTrue((boolean)set.contains("ou=configuration"));
        Assert.assertTrue((boolean)set.contains("prefNodeName=sysPrefRoot"));
        ctx.close();
    }

    @Test
    public void testSaslGssapiLdapAuth() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:1024");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "GSSAPI");
        LoginContext loginContext = new LoginContext("broker-sasl-gssapi");
        loginContext.login();
        try {
            Subject.doAs(loginContext.getSubject(), () -> {
                HashSet<String> set = new HashSet<String>();
                InitialDirContext ctx = new InitialDirContext(env);
                NamingEnumeration<NameClassPair> list = ctx.list("ou=system");
                while (list.hasMore()) {
                    NameClassPair ncp = list.next();
                    set.add(ncp.getName());
                }
                Assert.assertTrue((boolean)set.contains("uid=first"));
                Assert.assertTrue((boolean)set.contains("cn=users"));
                Assert.assertTrue((boolean)set.contains("ou=configuration"));
                Assert.assertTrue((boolean)set.contains("prefNodeName=sysPrefRoot"));
                ctx.close();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @Test
    public void testJAASSecurityManagerAuthorizationPositive() throws Exception {
        this.dotestJAASSecurityManagerAuthorizationPositive("Krb5PlusLdap", "admins");
    }

    @Test
    public void testJAASSecurityManagerAuthorizationPositiveMemberOf() throws Exception {
        this.dotestJAASSecurityManagerAuthorizationPositive("Krb5PlusLdapMemberOf", "bees");
    }

    @Test
    public void testJAASSecurityManagerAuthorizationPositiveNoRoleName() throws Exception {
        this.dotestJAASSecurityManagerAuthorizationPositive("Krb5PlusLdapNoRoleName", "cn=admins,ou=system");
    }

    @Test
    public void testJAASSecurityManagerAuthorizationPositiveMemberOfNoRoleName() throws Exception {
        this.dotestJAASSecurityManagerAuthorizationPositive("Krb5PlusLdapMemberOfNoRoleName", "cn=bees,ou=system");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dotestJAASSecurityManagerAuthorizationPositive(String jaasConfigScope, String artemisRoleName) throws Exception {
        this.createArtemisServer(jaasConfigScope);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role(artemisRoleName, true, true, true, true, true, true, true, true, true, true));
        this.server.getConfiguration().putSecurityRoles(QUEUE_NAME, roles);
        this.server.start();
        JmsConnectionFactory jmsConnectionFactory = new JmsConnectionFactory("amqp://localhost:5672?amqp.saslMechanisms=GSSAPI");
        try (Connection connection = jmsConnectionFactory.createConnection("client", null);){
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(QUEUE_NAME);
            String text = RandomUtil.randomString();
            try {
                MessageProducer producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage(text));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"should not throw exception here");
            }
            try {
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                TextMessage m = (TextMessage)consumer.receive(1000L);
                Assert.assertNotNull((Object)m);
                Assert.assertEquals((Object)text, (Object)m.getText());
            }
            catch (Exception e) {
                Assert.fail((String)"should not throw exception here");
            }
        }
    }

    private static /* synthetic */ void lambda$rewriteKerb5Conf$0(String line) {
        LOG.debug(line);
    }

    static {
        URL resource;
        LOG = LoggerFactory.getLogger(SaslKrb5LDAPSecurityTest.class);
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SaslKrb5LDAPSecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

