/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HeuristicXATest
extends ActiveMQTestBase {
    final SimpleString ADDRESS = new SimpleString("ADDRESS");
    final String body = "this is the body";
    private MBeanServer mbeanServer;
    private ServerLocator locator;

    @Test
    public void testInvalidCall() throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().setJMXManagementEnabled(true);
        ActiveMQServer server = this.createServer(false, configuration);
        server.setMBeanServer(this.mbeanServer);
        server.start();
        ActiveMQServerControl jmxServer = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        Assert.assertFalse((boolean)jmxServer.commitPreparedTransaction("Nananananana"));
    }

    @Test
    public void testHeuristicCommit() throws Exception {
        this.internalTest(true);
    }

    @Test
    public void testHeuristicRollback() throws Exception {
        this.internalTest(false);
    }

    private void internalTest(boolean isCommit) throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().setJMXManagementEnabled(true);
        ActiveMQServer server = this.createServer(false, configuration);
        server.setMBeanServer(this.mbeanServer);
        server.start();
        XidImpl xid = this.newXID();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(true, false, false);
        session.createQueue(new QueueConfiguration(this.ADDRESS));
        session.start((Xid)xid, 0);
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage msg = session.createMessage(true);
        msg.getBodyBuffer().writeString("this is the body");
        producer.send((Message)msg);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.close();
        ActiveMQServerControl jmxServer = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        String[] preparedTransactions = jmxServer.listPreparedTransactions();
        Assert.assertEquals((long)1L, (long)preparedTransactions.length);
        this.instanceLog.debug((Object)preparedTransactions[0]);
        Assert.assertEquals((long)0L, (long)jmxServer.listHeuristicCommittedTransactions().length);
        Assert.assertEquals((long)0L, (long)jmxServer.listHeuristicRolledBackTransactions().length);
        if (isCommit) {
            jmxServer.commitPreparedTransaction(XidImpl.toBase64String((Xid)xid));
        } else {
            jmxServer.rollbackPreparedTransaction(XidImpl.toBase64String((Xid)xid));
        }
        Assert.assertEquals((long)0L, (long)jmxServer.listPreparedTransactions().length);
        if (isCommit) {
            Assert.assertEquals((long)1L, (long)jmxServer.listHeuristicCommittedTransactions().length);
            Assert.assertEquals((long)0L, (long)jmxServer.listHeuristicRolledBackTransactions().length);
        } else {
            Assert.assertEquals((long)0L, (long)jmxServer.listHeuristicCommittedTransactions().length);
            Assert.assertEquals((long)1L, (long)jmxServer.listHeuristicRolledBackTransactions().length);
        }
        if (isCommit) {
            this.assertMessageInQueueThenReceiveAndCheckContent(server, sf);
        }
        Assert.assertEquals((long)0L, (long)this.getMessageCount((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()));
    }

    @Test
    public void testHeuristicCommitWithRestart() throws Exception {
        this.doHeuristicCompletionWithRestart(true);
    }

    @Test
    public void testHeuristicRollbackWithRestart() throws Exception {
        this.doHeuristicCompletionWithRestart(false);
    }

    private void doHeuristicCompletionWithRestart(boolean isCommit) throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().setJMXManagementEnabled(true);
        ActiveMQServer server = this.createServer(true, configuration);
        server.setMBeanServer(this.mbeanServer);
        server.start();
        XidImpl xid = this.newXID();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(true, false, false);
        session.createQueue(new QueueConfiguration(this.ADDRESS));
        session.start((Xid)xid, 0);
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage msg = session.createMessage(true);
        msg.getBodyBuffer().writeString("this is the body");
        producer.send((Message)msg);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.close();
        ActiveMQServerControl jmxServer = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        String[] preparedTransactions = jmxServer.listPreparedTransactions();
        Assert.assertEquals((long)1L, (long)preparedTransactions.length);
        this.instanceLog.debug((Object)preparedTransactions[0]);
        if (isCommit) {
            jmxServer.commitPreparedTransaction(XidImpl.toBase64String((Xid)xid));
        } else {
            jmxServer.rollbackPreparedTransaction(XidImpl.toBase64String((Xid)xid));
        }
        preparedTransactions = jmxServer.listPreparedTransactions();
        Assert.assertEquals((long)0L, (long)preparedTransactions.length);
        if (isCommit) {
            this.assertMessageInQueueThenReceiveAndCheckContent(server, sf);
        }
        Assert.assertEquals((long)0L, (long)this.getMessageCount((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()));
        server.stop();
        server.start();
        jmxServer = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        if (isCommit) {
            String[] listHeuristicCommittedTransactions = jmxServer.listHeuristicCommittedTransactions();
            Assert.assertEquals((long)1L, (long)listHeuristicCommittedTransactions.length);
            this.instanceLog.debug((Object)listHeuristicCommittedTransactions[0]);
        } else {
            String[] listHeuristicRolledBackTransactions = jmxServer.listHeuristicRolledBackTransactions();
            Assert.assertEquals((long)1L, (long)listHeuristicRolledBackTransactions.length);
            this.instanceLog.debug((Object)listHeuristicRolledBackTransactions[0]);
        }
    }

    @Test
    public void testRecoverHeuristicCommitWithRestart() throws Exception {
        this.doRecoverHeuristicCompletedTxWithRestart(true);
    }

    @Test
    public void testRecoverHeuristicRollbackWithRestart() throws Exception {
        this.doRecoverHeuristicCompletedTxWithRestart(false);
    }

    private void doRecoverHeuristicCompletedTxWithRestart(boolean heuristicCommit) throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().setJMXManagementEnabled(true);
        ActiveMQServer server = this.createServer(true, configuration);
        server.setMBeanServer(this.mbeanServer);
        server.start();
        XidImpl xid = this.newXID();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(true, false, false);
        session.createQueue(new QueueConfiguration(this.ADDRESS));
        session.start((Xid)xid, 0);
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage msg = session.createMessage(true);
        msg.getBodyBuffer().writeString("this is the body");
        producer.send((Message)msg);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.close();
        ActiveMQServerControl jmxServer = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        String[] preparedTransactions = jmxServer.listPreparedTransactions();
        Assert.assertEquals((long)1L, (long)preparedTransactions.length);
        this.instanceLog.debug((Object)preparedTransactions[0]);
        if (heuristicCommit) {
            jmxServer.commitPreparedTransaction(XidImpl.toBase64String((Xid)xid));
        } else {
            jmxServer.rollbackPreparedTransaction(XidImpl.toBase64String((Xid)xid));
        }
        preparedTransactions = jmxServer.listPreparedTransactions();
        Assert.assertEquals((long)0L, (long)preparedTransactions.length);
        if (heuristicCommit) {
            this.assertMessageInQueueThenReceiveAndCheckContent(server, sf);
        }
        Assert.assertEquals((long)0L, (long)this.getMessageCount((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()));
        server.stop();
        server.start();
        sf = this.createSessionFactory(this.locator);
        jmxServer = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        if (heuristicCommit) {
            String[] listHeuristicCommittedTransactions = jmxServer.listHeuristicCommittedTransactions();
            Assert.assertEquals((long)1L, (long)listHeuristicCommittedTransactions.length);
            this.instanceLog.debug((Object)listHeuristicCommittedTransactions[0]);
        } else {
            String[] listHeuristicRolledBackTransactions = jmxServer.listHeuristicRolledBackTransactions();
            Assert.assertEquals((long)1L, (long)listHeuristicRolledBackTransactions.length);
            this.instanceLog.debug((Object)listHeuristicRolledBackTransactions[0]);
        }
        session = sf.createSession(true, false, false);
        Xid[] recoveredXids = session.recover(0x1000000);
        Assert.assertEquals((long)1L, (long)recoveredXids.length);
        Assert.assertEquals((Object)xid, (Object)recoveredXids[0]);
        Assert.assertEquals((long)0L, (long)session.recover(0x800000).length);
        session.close();
    }

    private void assertMessageInQueueThenReceiveAndCheckContent(ActiveMQServer server, ClientSessionFactory sf) throws Exception {
        Wait.assertEquals((int)1, () -> this.getMessageCount((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()), (long)5000L, (long)100L);
        ClientSession session = sf.createSession(false, false, false);
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        msg.acknowledge();
        Assert.assertEquals((Object)"this is the body", (Object)msg.getBodyBuffer().readString());
        session.commit();
        session.close();
    }

    @Test
    public void testForgetHeuristicCommitAndRestart() throws Exception {
        this.doForgetHeuristicCompletedTxAndRestart(true);
    }

    @Test
    public void testForgetHeuristicRollbackAndRestart() throws Exception {
        this.doForgetHeuristicCompletedTxAndRestart(false);
    }

    private void doForgetHeuristicCompletedTxAndRestart(boolean heuristicCommit) throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().setJMXManagementEnabled(true);
        ActiveMQServer server = this.createServer(true, configuration);
        server.setMBeanServer(this.mbeanServer);
        server.start();
        XidImpl xid = this.newXID();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(true, false, false);
        session.createQueue(new QueueConfiguration(this.ADDRESS));
        session.start((Xid)xid, 0);
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage msg = session.createMessage(true);
        msg.getBodyBuffer().writeBytes(new byte[123]);
        producer.send((Message)msg);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        ActiveMQServerControl jmxServer = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        String[] preparedTransactions = jmxServer.listPreparedTransactions();
        Assert.assertEquals((long)1L, (long)preparedTransactions.length);
        this.instanceLog.debug((Object)preparedTransactions[0]);
        if (heuristicCommit) {
            jmxServer.commitPreparedTransaction(XidImpl.toBase64String((Xid)xid));
        } else {
            jmxServer.rollbackPreparedTransaction(XidImpl.toBase64String((Xid)xid));
        }
        preparedTransactions = jmxServer.listPreparedTransactions();
        Assert.assertEquals((long)0L, (long)preparedTransactions.length);
        session.forget((Xid)xid);
        session.close();
        if (heuristicCommit) {
            Assert.assertEquals((long)0L, (long)jmxServer.listHeuristicCommittedTransactions().length);
        } else {
            Assert.assertEquals((long)0L, (long)jmxServer.listHeuristicRolledBackTransactions().length);
        }
        server.stop();
        server.start();
        sf = this.createSessionFactory(this.locator);
        session = sf.createSession(true, false, false);
        Xid[] recoveredXids = session.recover(0x1000000);
        Assert.assertEquals((long)0L, (long)recoveredXids.length);
        jmxServer = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        if (heuristicCommit) {
            Assert.assertEquals((long)0L, (long)jmxServer.listHeuristicCommittedTransactions().length);
        } else {
            Assert.assertEquals((long)0L, (long)jmxServer.listHeuristicRolledBackTransactions().length);
        }
        session.close();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mbeanServer = MBeanServerFactory.createMBeanServer();
        this.locator = this.createInVMNonHALocator();
    }
}

