/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PageCleanupWhileReplicaCatchupTest
extends FailoverTestBase {
    private static final Logger logger = Logger.getLogger(PageCleanupWhileReplicaCatchupTest.class);
    volatile boolean running = true;

    @Override
    @Before
    public void setUp() throws Exception {
        this.startBackupServer = false;
        super.setUp();
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.getNettyAcceptorTransportConfiguration(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.getNettyConnectorTransportConfiguration(live);
    }

    protected ActiveMQServer createInVMFailoverServer(boolean realFiles, Configuration configuration, NodeManager nodeManager, int id) {
        HashMap<String, AddressSettings> conf = new HashMap<String, AddressSettings>();
        AddressSettings as = new AddressSettings().setMaxSizeBytes(2048L).setPageSizeBytes(1024).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        conf.put(ADDRESS.toString(), as);
        return this.createInVMFailoverServer(realFiles, configuration, 1024, 2048, conf, nodeManager, id);
    }

    @Test(timeout=120000L)
    public void testPageCleanup() throws Throwable {
        int i;
        int numberOfWorkers = 20;
        Worker[] workers = new Worker[numberOfWorkers];
        for (i = 0; i < 20; ++i) {
            this.liveServer.getServer().addAddressInfo(new AddressInfo("WORKER_" + i).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
            this.liveServer.getServer().createQueue(new QueueConfiguration("WORKER_" + i).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
            workers[i] = new Worker("WORKER_" + i);
            workers[i].start();
        }
        for (i = 0; i < 25; ++i) {
            logger.debug((Object)("Starting replica " + i));
            this.backupServer.start();
            Wait.assertTrue(() -> ((ActiveMQServer)this.backupServer.getServer()).isReplicaSync());
            this.backupServer.stop();
        }
        this.running = false;
        for (Worker worker : workers) {
            worker.join();
        }
        Throwable toThrow = null;
        for (Worker worker : workers) {
            if (worker.throwable == null) continue;
            worker.queue.getPagingStore().getCursorProvider().scheduleCleanup();
            Thread.sleep(2000L);
            worker.queue.getPagingStore().getCursorProvider().cleanup();
            System.out.println("PagingStore(" + worker.queueName + ")::isPaging() = " + worker.queue.getPagingStore().isPaging() + " after test failure " + worker.throwable.getMessage());
            toThrow = worker.throwable;
        }
        if (toThrow != null) {
            throw toThrow;
        }
        for (Worker worker : workers) {
            PagingStoreImpl storeImpl = (PagingStoreImpl)worker.queue.getPagingStore();
            Assert.assertTrue((String)("Store impl " + worker.queueName + " had more files than expected on " + storeImpl.getFolder()), (storeImpl.getNumberOfFiles() <= 1 ? (byte)1 : 0) != 0);
        }
    }

    class Worker
    extends Thread {
        final String queueName;
        final Queue queue;
        volatile Throwable throwable;

        Worker(String queue) {
            super("Worker on queue " + queue + " for test on PageCleanupWhileReplicaCatchupTest");
            this.queueName = queue;
            this.queue = PageCleanupWhileReplicaCatchupTest.this.liveServer.getServer().locateQueue(this.queueName);
        }

        @Override
        public void run() {
            try {
                ConnectionFactory factory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:61616");
                try (Connection connection = factory.createConnection();){
                    Session session = connection.createSession(false, 1);
                    connection.start();
                    jakarta.jms.Queue jmsQueue = session.createQueue(this.queueName);
                    MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
                    MessageProducer producer = session.createProducer((Destination)jmsQueue);
                    while (PageCleanupWhileReplicaCatchupTest.this.running) {
                        int i;
                        this.queue.getPagingStore().startPaging();
                        for (i = 0; i < 10; ++i) {
                            producer.send((Message)session.createTextMessage("hello " + i));
                        }
                        Wait.assertTrue(() -> ((PagingStore)this.queue.getPagingStore()).isPaging());
                        for (i = 0; i < 10; ++i) {
                            Assert.assertNotNull((Object)consumer.receive(5000L));
                        }
                        Wait.assertFalse((String)("Waiting for !Paging on " + this.queueName + " with folder " + this.queue.getPagingStore().getFolder()), () -> ((PagingStore)this.queue.getPagingStore()).isPaging());
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(System.out);
                this.throwable = e;
            }
        }
    }
}

