/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class PreACKJMSTest
extends JMSTestBase {
    private Queue queue;

    @Test
    public void testPreACKAuto() throws Exception {
        this.internalTestPreACK(1);
    }

    @Test
    public void testPreACKClientACK() throws Exception {
        this.internalTestPreACK(2);
    }

    @Test
    public void testPreACKDupsOK() throws Exception {
        this.internalTestPreACK(3);
    }

    public void internalTestPreACK(int sessionType) throws Exception {
        this.conn = this.cf.createConnection();
        Session sess = this.conn.createSession(false, sessionType);
        MessageProducer prod = sess.createProducer((Destination)this.queue);
        TextMessage msg1 = sess.createTextMessage("hello");
        prod.send((Message)msg1);
        this.conn.start();
        MessageConsumer cons = sess.createConsumer((Destination)this.queue);
        TextMessage msg2 = (TextMessage)cons.receive(1000L);
        PreACKJMSTest.assertNotNull((Object)msg2);
        PreACKJMSTest.assertEquals((Object)msg1.getText(), (Object)msg2.getText());
        this.conn.close();
        this.conn = this.cf.createConnection();
        this.conn.start();
        sess = this.conn.createSession(false, 2);
        cons = sess.createConsumer((Destination)this.queue);
        msg2 = (TextMessage)cons.receiveNoWait();
        PreACKJMSTest.assertNull((String)"ConnectionFactory is on PreACK mode, the message shouldn't be received", (Object)msg2);
    }

    @Test
    @Ignore
    public void testPreACKTransactional() throws Exception {
        this.conn = this.cf.createConnection();
        Session sess = this.conn.createSession(true, 0);
        MessageProducer prod = sess.createProducer((Destination)this.queue);
        TextMessage msg1 = sess.createTextMessage("hello");
        prod.send((Message)msg1);
        sess.commit();
        this.conn.start();
        MessageConsumer cons = sess.createConsumer((Destination)this.queue);
        TextMessage msg2 = (TextMessage)cons.receive(1000L);
        PreACKJMSTest.assertNotNull((Object)msg2);
        PreACKJMSTest.assertEquals((Object)msg1.getText(), (Object)msg2.getText());
        sess.rollback();
        this.conn.close();
        this.conn = this.cf.createConnection();
        this.conn.start();
        sess = this.conn.createSession(false, 2);
        cons = sess.createConsumer((Destination)this.queue);
        msg2 = (TextMessage)cons.receive(10L);
        PreACKJMSTest.assertNotNull((String)"ConnectionFactory is on PreACK mode but it is transacted", (Object)msg2);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.queue = this.createQueue("queue1");
    }

    @Override
    protected void createCF(List<TransportConfiguration> connectorConfigs, String ... jndiBindings) throws Exception {
        int retryInterval = 1000;
        double retryIntervalMultiplier = 1.0;
        int reconnectAttempts = -1;
        int callTimeout = 30000;
        ArrayList connectors = this.registerConnectors(this.server, connectorConfigs);
        this.jmsServer.createConnectionFactory("ManualReconnectionToSingleServerTest", false, JMSFactoryType.CF, (List)connectors, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, (long)callTimeout, 30000L, false, 102400, false, 0x100000, -1, -1, 65536, -1, false, true, false, false, true, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, true, 5, -1, (long)retryInterval, retryIntervalMultiplier, ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL, reconnectAttempts, false, null, jndiBindings);
    }
}

