/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressSettingsInfo;
import org.apache.activemq.artemis.cli.commands.tools.PrintData;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class DuplicateRecordIdTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig().addAddressesSetting("#", new AddressSettings().setDeadLetterAddress(new SimpleString("dlq")).setExpiryAddress(new SimpleString("dlq"))));
        this.server.getConfiguration().setPersistenceEnabled(true);
    }

    @Test
    public void testDuplicateRecordId() throws Exception {
        for (int i = 0; i < 3; ++i) {
            this.server.start();
            ActiveMQServerControlImpl serverControl = this.server.getActiveMQServerControl();
            serverControl.removeAddressSettings("q");
            AddressSettingsInfo defaultSettings = AddressSettingsInfo.from((String)serverControl.getAddressSettingsAsJSON("#"));
            serverControl.addAddressSettings("q", "dlq", defaultSettings.getExpiryAddress(), -1L, false, 1, defaultSettings.getMaxSizeBytes(), defaultSettings.getPageSizeBytes(), defaultSettings.getPageCacheMaxSize(), defaultSettings.getRedeliveryDelay(), defaultSettings.getRedeliveryMultiplier(), defaultSettings.getMaxRedeliveryDelay(), defaultSettings.getRedistributionDelay(), defaultSettings.isSendToDLAOnNoRoute(), defaultSettings.getAddressFullMessagePolicy(), defaultSettings.getSlowConsumerThreshold(), defaultSettings.getSlowConsumerCheckPeriod(), defaultSettings.getSlowConsumerPolicy(), defaultSettings.isAutoCreateJmsQueues(), defaultSettings.isAutoDeleteJmsQueues(), defaultSettings.isAutoCreateJmsQueues(), defaultSettings.isAutoDeleteJmsTopics());
            this.server.stop();
            PrintData.printData((File)this.server.getConfiguration().getBindingsLocation().getAbsoluteFile(), (File)this.server.getConfiguration().getJournalLocation().getAbsoluteFile(), (File)this.server.getConfiguration().getPagingLocation().getAbsoluteFile());
        }
    }
}

