/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class ManagementHelperTest
extends Assert {
    private static final Logger log = Logger.getLogger(ManagementHelperTest.class);

    @Test
    public void testArrayOfStringParameter() throws Exception {
        String resource = RandomUtil.randomString();
        String operationName = RandomUtil.randomString();
        String param = RandomUtil.randomString();
        String[] params = new String[]{RandomUtil.randomString(), RandomUtil.randomString(), RandomUtil.randomString()};
        ClientMessageImpl msg = new ClientMessageImpl(0, false, 0L, 0L, 4, 1000);
        ManagementHelper.putOperationInvocation((ICoreMessage)msg, (String)resource, (String)operationName, (Object[])new Object[]{param, params});
        Object[] parameters = ManagementHelper.retrieveOperationParameters((Message)msg);
        Assert.assertEquals((long)2L, (long)parameters.length);
        Assert.assertEquals((Object)param, (Object)parameters[0]);
        Object parameter_2 = parameters[1];
        log.debug((Object)("type " + parameter_2));
        Assert.assertTrue((boolean)(parameter_2 instanceof Object[]));
        Object[] retrievedParams = (Object[])parameter_2;
        Assert.assertEquals((long)params.length, (long)retrievedParams.length);
        for (int i = 0; i < retrievedParams.length; ++i) {
            Assert.assertEquals((Object)params[i], (Object)retrievedParams[i]);
        }
    }

    @Test
    public void testParams() throws Exception {
        String resource = RandomUtil.randomString();
        String operationName = RandomUtil.randomString();
        long i = RandomUtil.randomInt();
        String s = RandomUtil.randomString();
        double d = RandomUtil.randomDouble();
        boolean b = RandomUtil.randomBoolean();
        long l = RandomUtil.randomLong();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String key1 = RandomUtil.randomString();
        int value1 = RandomUtil.randomInt();
        String key2 = RandomUtil.randomString();
        double value2 = RandomUtil.randomDouble();
        String key3 = RandomUtil.randomString();
        String value3 = RandomUtil.randomString();
        String key4 = RandomUtil.randomString();
        boolean value4 = RandomUtil.randomBoolean();
        String key5 = RandomUtil.randomString();
        long value5 = RandomUtil.randomLong();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        String key2_1 = RandomUtil.randomString();
        int value2_1 = RandomUtil.randomInt();
        String key2_2 = RandomUtil.randomString();
        double value2_2 = RandomUtil.randomDouble();
        String key2_3 = RandomUtil.randomString();
        String value2_3 = RandomUtil.randomString();
        String key2_4 = RandomUtil.randomString();
        boolean value2_4 = RandomUtil.randomBoolean();
        String key2_5 = RandomUtil.randomString();
        long value2_5 = RandomUtil.randomLong();
        map2.put(key2_1, value2_1);
        map2.put(key2_2, value2_2);
        map2.put(key2_3, value2_3);
        map2.put(key2_4, value2_4);
        map2.put(key2_5, value2_5);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        String key3_1 = RandomUtil.randomString();
        int value3_1 = RandomUtil.randomInt();
        String key3_2 = RandomUtil.randomString();
        double value3_2 = RandomUtil.randomDouble();
        String key3_3 = RandomUtil.randomString();
        String value3_3 = RandomUtil.randomString();
        String key3_4 = RandomUtil.randomString();
        boolean value3_4 = RandomUtil.randomBoolean();
        String key3_5 = RandomUtil.randomString();
        long value3_5 = RandomUtil.randomLong();
        map3.put(key3_1, value3_1);
        map3.put(key3_2, value3_2);
        map3.put(key3_3, value3_3);
        map3.put(key3_4, value3_4);
        map3.put(key3_5, value3_5);
        Map[] maps = new Map[]{map2, map3};
        String strElem0 = RandomUtil.randomString();
        String strElem1 = RandomUtil.randomString();
        String strElem2 = RandomUtil.randomString();
        String[] strArray = new String[]{strElem0, strElem1, strElem2};
        Object[] params = new Object[]{i, s, d, b, l, map, strArray, maps};
        ClientMessageImpl msg = new ClientMessageImpl(0, false, 0L, 0L, 4, 1000);
        ManagementHelper.putOperationInvocation((ICoreMessage)msg, (String)resource, (String)operationName, (Object[])params);
        Object[] parameters = ManagementHelper.retrieveOperationParameters((Message)msg);
        Assert.assertEquals((long)params.length, (long)parameters.length);
        Assert.assertEquals((Object)i, (Object)parameters[0]);
        Assert.assertEquals((Object)s, (Object)parameters[1]);
        Assert.assertEquals((Object)d, (Object)parameters[2]);
        Assert.assertEquals((Object)b, (Object)parameters[3]);
        Assert.assertEquals((Object)l, (Object)parameters[4]);
        Map mapRes = (Map)parameters[5];
        Assert.assertEquals((long)map.size(), (long)mapRes.size());
        Assert.assertEquals((Object)value1, mapRes.get(key1));
        Assert.assertEquals((Object)value2, mapRes.get(key2));
        Assert.assertEquals((Object)value3, mapRes.get(key3));
        Assert.assertEquals((Object)value4, mapRes.get(key4));
        Assert.assertEquals((Object)value5, mapRes.get(key5));
        Object[] strArr2 = (Object[])parameters[6];
        Assert.assertEquals((long)strArray.length, (long)strArr2.length);
        Assert.assertEquals((Object)strElem0, (Object)strArr2[0]);
        Assert.assertEquals((Object)strElem1, (Object)strArr2[1]);
        Assert.assertEquals((Object)strElem2, (Object)strArr2[2]);
        Object[] mapArray = (Object[])parameters[7];
        Assert.assertEquals((long)2L, (long)mapArray.length);
        Map mapRes2 = (Map)mapArray[0];
        Assert.assertEquals((long)map2.size(), (long)mapRes2.size());
        Assert.assertEquals((Object)value2_1, mapRes2.get(key2_1));
        Assert.assertEquals((Object)value2_2, mapRes2.get(key2_2));
        Assert.assertEquals((Object)value2_3, mapRes2.get(key2_3));
        Assert.assertEquals((Object)value2_4, mapRes2.get(key2_4));
        Assert.assertEquals((Object)value2_5, mapRes2.get(key2_5));
        Map mapRes3 = (Map)mapArray[1];
        Assert.assertEquals((long)map3.size(), (long)mapRes3.size());
        Assert.assertEquals((Object)value3_1, mapRes3.get(key3_1));
        Assert.assertEquals((Object)value3_2, mapRes3.get(key3_2));
        Assert.assertEquals((Object)value3_3, mapRes3.get(key3_3));
        Assert.assertEquals((Object)value3_4, mapRes3.get(key3_4));
        Assert.assertEquals((Object)value3_5, mapRes3.get(key3_5));
    }

    @Test
    public void testMapWithArrayValues() throws Exception {
        String resource = RandomUtil.randomString();
        String operationName = RandomUtil.randomString();
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        String key1 = RandomUtil.randomString();
        Object[] val1 = new String[]{"a", "b", "c"};
        log.debug((Object)("val1 type is " + Arrays.toString(val1)));
        String key2 = RandomUtil.randomString();
        Object[] val2 = new Long[]{1L, 2L, 3L, 4L, 5L};
        log.debug((Object)("val2 type is " + Arrays.toString(val2)));
        map.put(key1, val1);
        map.put(key2, val2);
        Object[] params = new Object[]{"hello", map};
        ClientMessageImpl msg = new ClientMessageImpl(0, false, 0L, 0L, 4, 1000);
        ManagementHelper.putOperationInvocation((ICoreMessage)msg, (String)resource, (String)operationName, (Object[])params);
        Object[] parameters = ManagementHelper.retrieveOperationParameters((Message)msg);
        Assert.assertEquals((long)params.length, (long)parameters.length);
        Assert.assertEquals((Object)"hello", (Object)parameters[0]);
        Map map2 = (Map)parameters[1];
        Assert.assertEquals((long)2L, (long)map2.size());
        Object[] arr1 = (Object[])map2.get(key1);
        Assert.assertEquals((long)val1.length, (long)arr1.length);
        Assert.assertEquals((Object)arr1[0], (Object)val1[0]);
        Assert.assertEquals((Object)arr1[1], (Object)val1[1]);
        Assert.assertEquals((Object)arr1[2], (Object)val1[2]);
        Object[] arr2 = (Object[])map2.get(key2);
        Assert.assertEquals((long)val2.length, (long)arr2.length);
        Assert.assertEquals((Object)arr2[0], (Object)val2[0]);
        Assert.assertEquals((Object)arr2[1], (Object)val2[1]);
        Assert.assertEquals((Object)arr2[2], (Object)val2[2]);
    }
}

