/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.stomp.StompTest;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.junit.Test;

public class StompConnectionCleanupTest
extends StompTest {
    private static final long CONNECTION_TTL = 2000L;

    @Test
    public void testConnectionCleanupWithTopicSubscription() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompConnectionCleanupTest.subscribeTopic(this.conn, null, "auto", null);
        long start = System.currentTimeMillis();
        while (true) {
            int connCount = this.server.getRemotingService().getConnections().size();
            int sessionCount = this.server.getSessions().size();
            if (connCount == 0 && sessionCount == 0) break;
            Thread.sleep(10L);
            if (System.currentTimeMillis() - start <= 10000L) continue;
            StompConnectionCleanupTest.fail((String)"Timed out waiting for connection to be cleared up");
        }
    }

    @Test
    public void testConnectionCleanup() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        StompConnectionCleanupTest.subscribe(this.conn, null, "auto", null);
        StompConnectionCleanupTest.send(this.conn, StompConnectionCleanupTest.getQueuePrefix() + StompConnectionCleanupTest.getQueueName(), null, "Hello World");
        ClientStompFrame frame = this.conn.receiveFrame(10000L);
        StompConnectionCleanupTest.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
        StompConnectionCleanupTest.assertTrue((boolean)frame.getHeader("destination").equals(StompConnectionCleanupTest.getQueuePrefix() + StompConnectionCleanupTest.getQueueName()));
        long start = System.currentTimeMillis();
        while (true) {
            int connCount = this.server.getRemotingService().getConnections().size();
            int sessionCount = this.server.getSessions().size();
            if (connCount == 0 && sessionCount == 0) break;
            Thread.sleep(10L);
            if (System.currentTimeMillis() - start <= 10000L) continue;
            StompConnectionCleanupTest.fail((String)"Timed out waiting for connection to be cleared up");
        }
    }

    @Test
    public void testConnectionNotCleanedUp() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        long time = 6000L;
        long start = System.currentTimeMillis();
        do {
            StompConnectionCleanupTest.send(this.conn, StompConnectionCleanupTest.getQueuePrefix() + StompConnectionCleanupTest.getQueueName(), null, "Hello World");
            Message msg = consumer.receive(1000L);
            StompConnectionCleanupTest.assertNotNull((Object)msg);
            Thread.sleep(100L);
        } while (System.currentTimeMillis() - start <= time);
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        ActiveMQServer s = super.createServer();
        s.getConfiguration().setConnectionTTLOverride(2000L);
        return s;
    }
}

