/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.cli.commands.tools.journal.DecodeJournal;
import org.apache.activemq.artemis.cli.commands.tools.journal.EncodeJournal;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TestableJournal;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.SimpleFutureImpl;
import org.apache.activemq.artemis.utils.collections.SparseArrayLinkedList;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class JournalImplTestBase
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(JournalImplTestBase.class);
    protected List<RecordInfo> records = new LinkedList<RecordInfo>();
    protected TestableJournal journal;
    protected int recordLength = 1024;
    protected Map<Long, TransactionHolder> transactions = new LinkedHashMap<Long, TransactionHolder>();
    protected int maxAIO;
    protected int minFiles;
    protected int poolSize;
    protected int fileSize;
    protected boolean sync;
    protected String filePrefix = "amq";
    protected String fileExtension = "amq";
    protected SequentialFileFactory fileFactory;
    private final ReusableLatch latchDone = new ReusableLatch(0);
    private final ReusableLatch latchWait = new ReusableLatch(0);
    private Thread compactThread;

    @Before
    public void startLogger() {
        AssertionLoggerHandler.startCapture();
    }

    @After
    public void stopLogger() {
        try {
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ144009"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.resetFileFactory();
        this.fileFactory.start();
        this.transactions.clear();
        this.records.clear();
    }

    @After
    public void tearDown() throws Exception {
        JournalImplTestBase.stopComponent((ActiveMQComponent)this.journal);
        if (this.fileFactory != null) {
            this.fileFactory.stop();
        }
        this.fileFactory = null;
        this.journal = null;
        super.tearDown();
    }

    protected void resetFileFactory() throws Exception {
        if (this.fileFactory != null) {
            this.fileFactory.stop();
        }
        this.fileFactory = this.getFileFactory();
    }

    protected void checkAndReclaimFiles() throws Exception {
        this.journal.debugWait();
        boolean originalAutoReclaim = this.journal.isAutoReclaim();
        this.journal.setAutoReclaim(true);
        this.journal.checkReclaimStatus();
        this.journal.setAutoReclaim(originalAutoReclaim);
        this.journal.debugWait();
    }

    protected abstract SequentialFileFactory getFileFactory() throws Exception;

    protected void setup(int minFreeFiles, int fileSize, boolean sync, int maxAIO) {
        this.minFiles = minFreeFiles;
        this.poolSize = minFreeFiles;
        this.fileSize = fileSize;
        this.sync = sync;
        this.maxAIO = maxAIO;
    }

    protected void setup(int minFreeFiles, int poolSize, int fileSize, boolean sync, int maxAIO) {
        this.minFiles = minFreeFiles;
        this.poolSize = poolSize;
        this.fileSize = fileSize;
        this.sync = sync;
        this.maxAIO = maxAIO;
    }

    protected void setup(int minFreeFiles, int fileSize, boolean sync) {
        this.minFiles = minFreeFiles;
        this.poolSize = minFreeFiles;
        this.fileSize = fileSize;
        this.sync = sync;
        this.maxAIO = 50;
    }

    protected boolean suportsRetention() {
        return true;
    }

    public void createJournal() throws Exception {
        this.journal = new JournalImpl(this.fileSize, this.minFiles, this.poolSize, 0, 0, this.fileFactory, this.filePrefix, this.fileExtension, this.maxAIO){

            public void onCompactDone() {
                JournalImplTestBase.this.latchDone.countDown();
                try {
                    JournalImplTestBase.this.latchWait.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.suportsRetention()) {
            File fileBackup = new File(this.getTestDir(), "backupFoler");
            fileBackup.mkdirs();
            ((JournalImpl)this.journal).setHistoryFolder(fileBackup, -1L, -1L);
        }
        this.journal.setAutoReclaim(false);
        this.addActiveMQComponent((ActiveMQComponent)this.journal);
    }

    protected void startCompact() throws Exception {
        this.latchDone.setCount(1);
        this.latchWait.setCount(1);
        this.compactThread = new Thread(){

            @Override
            public void run() {
                try {
                    JournalImplTestBase.this.journal.testCompact();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.compactThread.start();
        this.latchDone.await();
    }

    protected void finishCompact() throws Exception {
        this.latchWait.countDown();
        this.compactThread.join();
    }

    protected void startJournal() throws Exception {
        this.journal.start();
    }

    protected void stopJournal() throws Exception {
        this.stopJournal(true);
    }

    protected void stopJournal(boolean reclaim) throws Exception {
        this.journal.flush();
        if (reclaim) {
            this.checkAndReclaimFiles();
        }
        this.journal.stop();
    }

    protected void exportImportJournal() throws Exception {
        File[] files;
        log.debug((Object)("Exporting to " + this.getTestDir() + "/output.log"));
        EncodeJournal.exportJournal((String)this.getTestDir(), (String)this.filePrefix, (String)this.fileExtension, (int)this.minFiles, (int)this.fileSize, (String)(this.getTestDir() + "/output.log"));
        File dir = new File(this.getTestDir());
        FilenameFilter fnf = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith("." + JournalImplTestBase.this.fileExtension);
            }
        };
        log.debug((Object)("file = " + dir));
        for (File file : files = dir.listFiles(fnf)) {
            log.debug((Object)("Deleting " + file));
            file.delete();
        }
        DecodeJournal.importJournal((String)this.getTestDir(), (String)this.filePrefix, (String)this.fileExtension, (int)this.minFiles, (int)this.fileSize, (String)(this.getTestDir() + "/output.log"));
    }

    protected void loadAndCheck() throws Exception {
        this.loadAndCheck(false);
    }

    private static void describeJournal(SequentialFileFactory fileFactory, JournalImpl journal, File path, final PrintStream out) throws Exception {
        List files = journal.orderFiles();
        out.println("Journal path: " + path);
        for (JournalFile file : files) {
            out.println("#" + file + " (size=" + file.getFile().size() + ")");
            JournalImpl.readJournalFile((SequentialFileFactory)fileFactory, (JournalFile)file, (JournalReaderCallback)new JournalReaderCallback(){

                public void onReadUpdateRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@UpdateTX;txID=" + transactionID + "," + recordInfo);
                }

                public void onReadUpdateRecord(RecordInfo recordInfo) throws Exception {
                    out.println("operation@Update;" + recordInfo);
                }

                public void onReadRollbackRecord(long transactionID) throws Exception {
                    out.println("operation@Rollback;txID=" + transactionID);
                }

                public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                    out.println("operation@Prepare,txID=" + transactionID + ",numberOfRecords=" + numberOfRecords);
                }

                public void onReadDeleteRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@DeleteRecordTX;txID=" + transactionID + "," + recordInfo);
                }

                public void onReadDeleteRecord(long recordID) throws Exception {
                    out.println("operation@DeleteRecord;recordID=" + recordID);
                }

                public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                    out.println("operation@Commit;txID=" + transactionID + ",numberOfRecords=" + numberOfRecords);
                }

                public void onReadAddRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@AddRecordTX;txID=" + transactionID + "," + recordInfo);
                }

                public void onReadAddRecord(RecordInfo recordInfo) throws Exception {
                    out.println("operation@AddRecord;" + recordInfo);
                }

                public void markAsDataFile(JournalFile file1) {
                }
            });
        }
        out.println();
    }

    protected void loadAndCheck(boolean printDebugJournal) throws Exception {
        ArrayList<RecordInfo> committedRecords = new ArrayList<RecordInfo>();
        ArrayList<PreparedTransactionInfo> preparedTransactions = new ArrayList<PreparedTransactionInfo>();
        this.journal.load(committedRecords, preparedTransactions, null);
        this.checkRecordsEquivalent(this.records, committedRecords);
        if (printDebugJournal) {
            this.printJournalLists(this.records, committedRecords);
        }
        ArrayList<PreparedTransactionInfo> prepared = new ArrayList<PreparedTransactionInfo>();
        for (Map.Entry<Long, TransactionHolder> entry : this.transactions.entrySet()) {
            if (!entry.getValue().prepared) continue;
            PreparedTransactionInfo info = new PreparedTransactionInfo(entry.getKey().longValue(), null);
            info.getRecords().addAll(entry.getValue().records);
            info.getRecordsToDelete().addAll(entry.getValue().deletes);
            prepared.add(info);
        }
        this.checkTransactionsEquivalent(prepared, preparedTransactions);
    }

    protected void load() throws Exception {
        this.journal.load(new SparseArrayLinkedList(), null, null);
    }

    protected void beforeJournalOperation() throws Exception {
    }

    protected void add(long ... arguments) throws Exception {
        this.addWithSize(this.recordLength, arguments);
    }

    protected void addWithSize(int size, long ... arguments) throws Exception {
        for (long element : arguments) {
            byte[] record = this.generateRecord(size);
            this.beforeJournalOperation();
            this.journal.appendAddRecord(element, (byte)0, record, this.sync);
            this.records.add(new RecordInfo(element, 0, record, false, false, 0));
        }
        this.journal.debugWait();
    }

    protected boolean tryUpdate(long argument) throws Exception {
        byte[] updateRecord = this.generateRecord(this.recordLength);
        this.beforeJournalOperation();
        SimpleFutureImpl future = new SimpleFutureImpl();
        this.journal.tryAppendUpdateRecord(argument, (byte)0, updateRecord, (r, b) -> future.set((Object)b), this.sync, false);
        if (((Boolean)future.get()).booleanValue()) {
            Assert.fail();
            this.records.add(new RecordInfo(argument, 0, updateRecord, true, false, 0));
        }
        return (Boolean)future.get();
    }

    protected void update(long ... arguments) throws Exception {
        for (long element : arguments) {
            byte[] updateRecord = this.generateRecord(this.recordLength);
            this.beforeJournalOperation();
            this.journal.appendUpdateRecord(element, (byte)0, updateRecord, this.sync);
            this.records.add(new RecordInfo(element, 0, updateRecord, true, false, 0));
        }
        this.journal.debugWait();
    }

    protected void delete(long ... arguments) throws Exception {
        for (long element : arguments) {
            this.beforeJournalOperation();
            this.journal.appendDeleteRecord(element, this.sync);
            this.removeRecordsForID(element);
        }
        this.journal.debugWait();
    }

    protected boolean tryDelete(long argument) throws Exception {
        this.beforeJournalOperation();
        AtomicBoolean result = new AtomicBoolean(true);
        this.journal.tryAppendDeleteRecord(argument, (t, b) -> result.set(b), this.sync);
        if (result.get()) {
            this.removeRecordsForID(argument);
        }
        this.journal.debugWait();
        return result.get();
    }

    protected void addTx(long txID, long ... arguments) throws Exception {
        TransactionHolder tx = this.getTransaction(txID);
        for (long element : arguments) {
            byte[] record = this.generateRecord(this.recordLength - 31);
            this.beforeJournalOperation();
            this.journal.appendAddRecordTransactional(txID, element, (byte)0, record);
            tx.records.add(new RecordInfo(element, 0, record, false, false, 0));
        }
        this.journal.debugWait();
    }

    protected void updateTx(long txID, long ... arguments) throws Exception {
        TransactionHolder tx = this.getTransaction(txID);
        for (long element : arguments) {
            byte[] updateRecord = this.generateRecord(this.recordLength - 31);
            this.beforeJournalOperation();
            this.journal.appendUpdateRecordTransactional(txID, element, (byte)0, updateRecord);
            tx.records.add(new RecordInfo(element, 0, updateRecord, true, false, 0));
        }
        this.journal.debugWait();
    }

    protected void deleteTx(long txID, long ... arguments) throws Exception {
        TransactionHolder tx = this.getTransaction(txID);
        for (long element : arguments) {
            this.beforeJournalOperation();
            this.journal.appendDeleteRecordTransactional(txID, element);
            tx.deletes.add(new RecordInfo(element, 0, null, true, false, 0));
        }
        this.journal.debugWait();
    }

    protected void prepare(long txID, EncodingSupport xid) throws Exception {
        TransactionHolder tx = this.transactions.get(txID);
        if (tx == null) {
            tx = new TransactionHolder();
            this.transactions.put(txID, tx);
        }
        if (tx.prepared) {
            throw new IllegalStateException("Transaction is already prepared");
        }
        this.beforeJournalOperation();
        this.journal.appendPrepareRecord(txID, xid, this.sync);
        tx.prepared = true;
        this.journal.debugWait();
    }

    protected void commit(long txID) throws Exception {
        TransactionHolder tx = this.transactions.remove(txID);
        if (tx == null) {
            throw new IllegalStateException("Cannot find tx " + txID);
        }
        this.beforeJournalOperation();
        this.journal.appendCommitRecord(txID, this.sync);
        this.records.addAll(tx.records);
        for (RecordInfo l : tx.deletes) {
            this.removeRecordsForID(l.id);
        }
        this.journal.debugWait();
    }

    protected void rollback(long txID) throws Exception {
        TransactionHolder tx = this.transactions.remove(txID);
        if (tx == null) {
            throw new IllegalStateException("Cannot find tx " + txID);
        }
        this.beforeJournalOperation();
        this.journal.appendRollbackRecord(txID, this.sync);
        this.journal.debugWait();
    }

    protected void removeRecordsForID(long id) {
        ListIterator<RecordInfo> iter = this.records.listIterator();
        while (iter.hasNext()) {
            RecordInfo info = iter.next();
            if (info.id != id) continue;
            iter.remove();
        }
    }

    protected TransactionHolder getTransaction(long txID) {
        TransactionHolder tx = this.transactions.get(txID);
        if (tx == null) {
            tx = new TransactionHolder();
            this.transactions.put(txID, tx);
        }
        return tx;
    }

    protected void checkTransactionsEquivalent(List<PreparedTransactionInfo> expected, List<PreparedTransactionInfo> actual) {
        Assert.assertEquals((String)"Lists not same length", (long)expected.size(), (long)actual.size());
        Iterator<PreparedTransactionInfo> iterExpected = expected.iterator();
        Iterator<PreparedTransactionInfo> iterActual = actual.iterator();
        while (iterExpected.hasNext()) {
            PreparedTransactionInfo rexpected = iterExpected.next();
            PreparedTransactionInfo ractual = iterActual.next();
            Assert.assertEquals((String)"ids not same", (long)rexpected.getId(), (long)ractual.getId());
            this.checkRecordsEquivalent(rexpected.getRecords(), ractual.getRecords());
            Assert.assertEquals((String)"deletes size not same", (long)rexpected.getRecordsToDelete().size(), (long)ractual.getRecordsToDelete().size());
            Iterator iterDeletesExpected = rexpected.getRecordsToDelete().iterator();
            Iterator iterDeletesActual = ractual.getRecordsToDelete().iterator();
            while (iterDeletesExpected.hasNext()) {
                long lexpected = ((RecordInfo)iterDeletesExpected.next()).id;
                long lactual = ((RecordInfo)iterDeletesActual.next()).id;
                Assert.assertEquals((String)"Delete ids not same", (long)lexpected, (long)lactual);
            }
        }
    }

    protected void checkRecordsEquivalent(List<RecordInfo> expected, List<RecordInfo> actual) {
        if (expected.size() != actual.size()) {
            this.printJournalLists(expected, actual);
        }
        Assert.assertEquals((String)"Lists not same length", (long)expected.size(), (long)actual.size());
        Iterator<RecordInfo> iterExpected = expected.iterator();
        Iterator<RecordInfo> iterActual = actual.iterator();
        while (iterExpected.hasNext()) {
            RecordInfo rexpected = iterExpected.next();
            RecordInfo ractual = iterActual.next();
            if (rexpected.id != ractual.id || rexpected.isUpdate != ractual.isUpdate) {
                this.printJournalLists(expected, actual);
            }
            Assert.assertEquals((String)"ids not same", (long)rexpected.id, (long)ractual.id);
            Assert.assertEquals((String)"type not same", (Object)rexpected.isUpdate, (Object)ractual.isUpdate);
            ActiveMQTestBase.assertEqualsByteArrays((byte[])rexpected.data, (byte[])ractual.data);
        }
    }

    protected void printJournalLists(List<RecordInfo> expected, List<RecordInfo> actual) {
        try {
            HashSet<RecordInfo> expectedSet = new HashSet<RecordInfo>();
            expectedSet.addAll(expected);
            Assert.assertEquals((String)"There are duplicated on the expected list", (long)expectedSet.size(), (long)expected.size());
            HashSet<RecordInfo> actualSet = new HashSet<RecordInfo>();
            actualSet.addAll(actual);
            expectedSet.removeAll(actualSet);
            for (RecordInfo info : expectedSet) {
                log.warn((Object)("The following record is missing:: " + info));
            }
            Assert.assertEquals((String)"There are duplicates on the actual list", (long)actualSet.size(), (long)actualSet.size());
            Object[] expectedArray = expected.toArray(new RecordInfo[expected.size()]);
            Object[] actualArray = actual.toArray(new RecordInfo[actual.size()]);
            Assert.assertArrayEquals((Object[])expectedArray, (Object[])actualArray);
        }
        catch (AssertionError e) {
            HashSet<RecordInfo> hashActual = new HashSet<RecordInfo>();
            hashActual.addAll(actual);
            HashSet<RecordInfo> hashExpected = new HashSet<RecordInfo>();
            hashExpected.addAll(expected);
            log.debug((Object)"#Summary **********************************************************************************************************************");
            for (RecordInfo r : hashActual) {
                if (hashExpected.contains(r)) continue;
                log.debug((Object)("Record " + r + " was supposed to be removed and it exists"));
            }
            for (RecordInfo r : hashExpected) {
                if (hashActual.contains(r)) continue;
                log.debug((Object)("Record " + r + " was not found on actual list"));
            }
            log.debug((Object)"#expected **********************************************************************************************************************");
            for (RecordInfo recordInfo : expected) {
                log.debug((Object)("Record::" + recordInfo));
            }
            log.debug((Object)"#actual ************************************************************************************************************************");
            for (RecordInfo recordInfo : actual) {
                log.debug((Object)("Record::" + recordInfo));
            }
            log.debug((Object)"#records ***********************************************************************************************************************");
            try {
                JournalImplTestBase.describeJournal(this.journal.getFileFactory(), (JournalImpl)this.journal, this.journal.getFileFactory().getDirectory(), System.out);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    protected byte[] generateRecord(int length) {
        byte[] record = new byte[length];
        for (int i = 0; i < length; ++i) {
            record[i] = ActiveMQTestBase.getSamplebyte((long)i);
        }
        return record;
    }

    protected String debugJournal() throws Exception {
        return "***************************************************\n" + ((JournalImpl)this.journal).debug() + "***************************************************\n";
    }

    static final class TransactionHolder {
        List<RecordInfo> records = new ArrayList<RecordInfo>();
        List<RecordInfo> deletes = new ArrayList<RecordInfo>();
        boolean prepared;

        TransactionHolder() {
        }
    }
}

