/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.junit.Assert;
import org.junit.Test;

public class VersionLoaderTest
extends ActiveMQTestBase {
    @Test
    public void testLoadVersion() throws Exception {
        Version version = VersionLoader.getVersion();
        Properties props = new Properties();
        props.load(ClassLoader.getSystemResourceAsStream("activemq-version.properties"));
        Assert.assertEquals((Object)props.get("activemq.version.versionName"), (Object)version.getVersionName());
        Assert.assertEquals((long)Integer.parseInt(props.getProperty("activemq.version.majorVersion")), (long)version.getMajorVersion());
        Assert.assertEquals((long)Integer.parseInt(props.getProperty("activemq.version.minorVersion")), (long)version.getMinorVersion());
        Assert.assertEquals((long)Integer.parseInt(props.getProperty("activemq.version.microVersion")), (long)version.getMicroVersion());
        Assert.assertEquals((long)Integer.parseInt(new StringTokenizer(props.getProperty("activemq.version.incrementingVersion"), ",").nextToken()), (long)version.getIncrementingVersion());
    }
}

