/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.job.repository;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.jberet.repository.JobRepository;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.batch.jberet.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.jberet._private.Capabilities;
import org.wildfly.extension.batch.jberet.job.repository.CommonAttributes;
import org.wildfly.extension.batch.jberet.job.repository.JdbcJobRepositoryService;

public class JdbcJobRepositoryDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "jdbc-job-repository";
    public static final PathElement PATH = PathElement.pathElement((String)"jdbc-job-repository");
    public static final SimpleAttributeDefinition DATA_SOURCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"data-source", (ModelType)ModelType.STRING, (boolean)false).setCapabilityReference("org.wildfly.data-source", Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), true)).setRestartAllServices()).build();

    public JdbcJobRepositoryDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, (ResourceDescriptionResolver)BatchResourceDescriptionResolver.getResourceDescriptionResolver(NAME)).setAddHandler((OperationStepHandler)new JdbcRepositoryAddHandler()).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler(new RuntimeCapability[]{Capabilities.JOB_REPOSITORY_CAPABILITY})).setCapabilities(new RuntimeCapability[]{Capabilities.JOB_REPOSITORY_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DATA_SOURCE, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{DATA_SOURCE}));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CommonAttributes.EXECUTION_RECORDS_LIMIT, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{CommonAttributes.EXECUTION_RECORDS_LIMIT}));
    }

    private static class JdbcRepositoryAddHandler
    extends AbstractAddStepHandler {
        JdbcRepositoryAddHandler() {
            super(Capabilities.JOB_REPOSITORY_CAPABILITY, new AttributeDefinition[]{DATA_SOURCE, CommonAttributes.EXECUTION_RECORDS_LIMIT});
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            String name = context.getCurrentAddressValue();
            String dsName = DATA_SOURCE.resolveModelAttribute(context, model).asString();
            Integer executionRecordsLimit = CommonAttributes.EXECUTION_RECORDS_LIMIT.resolveModelAttribute(context, model).asIntOrNull();
            ServiceTarget target = context.getServiceTarget();
            ServiceName sn = context.getCapabilityServiceName(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), name, JobRepository.class);
            ServiceBuilder sb = target.addService(sn);
            Consumer jobRepositoryConsumer = sb.provides(new ServiceName[]{sn});
            Supplier executorSupplier = Services.requireServerExecutor((ServiceBuilder)sb);
            Supplier dataSourceSupplier = sb.requires(context.getCapabilityServiceName("org.wildfly.data-source", dsName, DataSource.class));
            JdbcJobRepositoryService service = new JdbcJobRepositoryService(jobRepositoryConsumer, dataSourceSupplier, executorSupplier, executionRecordsLimit);
            sb.setInstance((Service)service);
            sb.install();
        }
    }
}

