/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.xnio.IoUtils;

public class URLResource
implements Resource,
RangeAwareResource {
    private final URL url;
    private final String path;
    private boolean connectionOpened = false;
    private Date lastModified;
    private Long contentLength;

    @Deprecated
    public URLResource(URL url, URLConnection connection, String path) {
        this(url, path);
    }

    public URLResource(URL url, String path) {
        this.url = url;
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Date getLastModified() {
        this.openConnection();
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openConnection() {
        if (!this.connectionOpened) {
            this.connectionOpened = true;
            URLConnection connection = null;
            try {
                try {
                    connection = this.url.openConnection();
                }
                catch (IOException e) {
                    this.lastModified = null;
                    this.contentLength = null;
                    if (connection != null) {
                        try {
                            IoUtils.safeClose((Closeable)connection.getInputStream());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return;
                }
                if (this.url.getProtocol().equals("jar")) {
                    connection.setUseCaches(false);
                    URL jar = ((JarURLConnection)connection).getJarFileURL();
                    this.lastModified = new Date(new File(jar.getFile()).lastModified());
                } else {
                    this.lastModified = new Date(connection.getLastModified());
                }
                this.contentLength = connection.getContentLengthLong();
            }
            finally {
                if (connection != null) {
                    try {
                        IoUtils.safeClose((Closeable)connection.getInputStream());
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public String getLastModifiedString() {
        return DateUtils.toDateString(this.getLastModified());
    }

    @Override
    public ETag getETag() {
        return null;
    }

    @Override
    public String getName() {
        int sepIndex;
        String path = this.url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((sepIndex = path.lastIndexOf("/")) != -1) {
            path = path.substring(sepIndex + 1);
        }
        return path;
    }

    @Override
    public boolean isDirectory() {
        Path file = this.getFilePath();
        if (file != null) {
            return Files.isDirectory(file, new LinkOption[0]);
        }
        return this.url.getPath().endsWith("/");
    }

    @Override
    public List<Resource> list() {
        LinkedList<Resource> result;
        block9: {
            result = new LinkedList<Resource>();
            Path file = this.getFilePath();
            try {
                if (file == null) break block9;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(file);){
                    for (Path child : stream) {
                        result.add(new URLResource(child.toUri().toURL(), child.toString()));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.getName();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    @Override
    public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
        this.serveImpl(sender, exchange, -1L, -1L, false, completionCallback);
    }

    public void serveImpl(final Sender sender, final HttpServerExchange exchange, final long start, final long end, final boolean range, final IoCallback completionCallback) {
        class ServerTask
        implements Runnable,
        IoCallback {
            private InputStream inputStream;
            private byte[] buffer;
            long toSkip;
            long remaining;

            ServerTask() {
                this.toSkip = start;
                this.remaining = end - start + 1L;
            }

            @Override
            public void run() {
                if (range && this.remaining == 0L) {
                    IoUtils.safeClose((Closeable)this.inputStream);
                    completionCallback.onComplete(exchange, sender);
                    return;
                }
                if (this.inputStream == null) {
                    try {
                        this.inputStream = URLResource.this.url.openStream();
                    }
                    catch (IOException e) {
                        exchange.setStatusCode(500);
                        return;
                    }
                    this.buffer = new byte[1024];
                }
                try {
                    int res = this.inputStream.read(this.buffer);
                    if (res == -1) {
                        IoUtils.safeClose((Closeable)this.inputStream);
                        completionCallback.onComplete(exchange, sender);
                        return;
                    }
                    int bufferStart = 0;
                    int length = res;
                    if (range && this.toSkip > 0L) {
                        while (this.toSkip > (long)res) {
                            this.toSkip -= (long)res;
                            res = this.inputStream.read(this.buffer);
                            if (res != -1) continue;
                            IoUtils.safeClose((Closeable)this.inputStream);
                            completionCallback.onComplete(exchange, sender);
                            return;
                        }
                        bufferStart = (int)this.toSkip;
                        length = (int)((long)length - this.toSkip);
                        this.toSkip = 0L;
                    }
                    if (range && (long)length > this.remaining) {
                        length = (int)this.remaining;
                    }
                    sender.send(ByteBuffer.wrap(this.buffer, bufferStart, length), (IoCallback)this);
                }
                catch (IOException e) {
                    this.onException(exchange, sender, e);
                }
            }

            @Override
            public void onComplete(HttpServerExchange exchange2, Sender sender2) {
                if (exchange2.isInIoThread()) {
                    exchange2.dispatch(this);
                } else {
                    this.run();
                }
            }

            @Override
            public void onException(HttpServerExchange exchange2, Sender sender2, IOException exception) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                IoUtils.safeClose((Closeable)this.inputStream);
                if (!exchange2.isResponseStarted()) {
                    exchange2.setStatusCode(500);
                }
                completionCallback.onException(exchange2, sender2, exception);
            }
        }
        ServerTask serveTask = new ServerTask();
        if (exchange.isInIoThread()) {
            exchange.dispatch(serveTask);
        } else {
            serveTask.run();
        }
    }

    @Override
    public Long getContentLength() {
        this.openConnection();
        return this.contentLength;
    }

    @Override
    public String getCacheKey() {
        return this.url.toString();
    }

    @Override
    public File getFile() {
        Path path = this.getFilePath();
        return path != null ? path.toFile() : null;
    }

    @Override
    public Path getFilePath() {
        if (this.url.getProtocol().equals("file")) {
            try {
                return Paths.get(this.url.toURI());
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public File getResourceManagerRoot() {
        return null;
    }

    @Override
    public Path getResourceManagerRootPath() {
        return null;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void serveRange(Sender sender, HttpServerExchange exchange, long start, long end, IoCallback completionCallback) {
        this.serveImpl(sender, exchange, start, end, true, completionCallback);
    }

    @Override
    public boolean isRangeSupported() {
        return true;
    }
}

