/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.derived;

import jakarta.persistence.metamodel.Bindable;
import org.hibernate.Incubating;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.JavaType;

@Incubating
public class AnonymousTupleSimpleSqmPathSource<J>
implements SqmPathSource<J> {
    private final String localPathName;
    private final DomainType<J> domainType;
    private final Bindable.BindableType jpaBindableType;

    public AnonymousTupleSimpleSqmPathSource(String localPathName, DomainType<J> domainType, Bindable.BindableType jpaBindableType) {
        this.localPathName = localPathName;
        this.domainType = domainType;
        this.jpaBindableType = jpaBindableType;
    }

    @Override
    public Class<J> getBindableJavaType() {
        return this.domainType.getBindableJavaType();
    }

    @Override
    public String getPathName() {
        return this.localPathName;
    }

    @Override
    public DomainType<?> getSqmPathType() {
        return this.domainType;
    }

    public Bindable.BindableType getBindableType() {
        return this.jpaBindableType;
    }

    @Override
    public JavaType<J> getExpressibleJavaType() {
        return this.domainType.getExpressibleJavaType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        throw new IllegalStateException("Basic paths cannot be dereferenced");
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        NavigablePath navigablePath = intermediatePathSource == null ? lhs.getNavigablePath().append(this.getPathName()) : lhs.getNavigablePath().append(intermediatePathSource.getPathName()).append(this.getPathName());
        return new SqmBasicValuedSimplePath(navigablePath, this, lhs, lhs.nodeBuilder());
    }
}

