/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.application.ViewVisitOption;
import jakarta.faces.component.UIViewParameter;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.ViewDeclarationLanguage;
import jakarta.faces.view.ViewDeclarationLanguageFactory;
import jakarta.faces.view.ViewMetadata;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.MappingMatch;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class MultiViewHandler
extends ViewHandler {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private List<String> configuredExtensions;
    private Set<String> protectedViews;
    private ViewDeclarationLanguageFactory vdlFactory;

    public MultiViewHandler() {
        WebConfiguration config = WebConfiguration.getInstance();
        this.configuredExtensions = config.getConfiguredExtensions();
        this.vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"jakarta.faces.view.ViewDeclarationLanguageFactory");
        this.protectedViews = new CopyOnWriteArraySet<String>();
    }

    public void initView(FacesContext context) throws FacesException {
        super.initView(context);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        String physicalViewId = this.derivePhysicalViewId(context, viewId, false);
        return this.vdlFactory.getViewDeclarationLanguage(physicalViewId).restoreView(context, physicalViewId);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        String physicalViewId = this.derivePhysicalViewId(context, viewId, false);
        return this.vdlFactory.getViewDeclarationLanguage(physicalViewId).createView(context, physicalViewId);
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        Util.notNull("context", context);
        Util.notNull("viewToRender", viewToRender);
        this.vdlFactory.getViewDeclarationLanguage(viewToRender.getViewId()).renderView(context, viewToRender);
    }

    public Locale calculateLocale(FacesContext context) {
        Locale perf;
        Util.notNull("context", context);
        Locale result = null;
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext() && (result = this.findMatch(context, perf = (Locale)locales.next())) == null) {
        }
        if (result == null) {
            result = context.getApplication().getDefaultLocale() == null ? Locale.getDefault() : context.getApplication().getDefaultLocale();
        }
        return result;
    }

    public String calculateRenderKitId(FacesContext context) {
        Util.notNull("context", context);
        String result = RenderKitUtils.PredefinedPostbackParameter.RENDER_KIT_ID_PARAM.getValue(context);
        if (result == null && null == (result = context.getApplication().getDefaultRenderKitId())) {
            result = "HTML_BASIC";
        }
        return result;
    }

    public void writeState(FacesContext context) throws IOException {
        Util.notNull("context", context);
        if (!context.getPartialViewContext().isAjaxRequest()) {
            LOGGER.fine(() -> "Begin writing marker for viewId " + context.getViewRoot().getViewId());
            WriteBehindStateWriter writer = WriteBehindStateWriter.getCurrentInstance();
            if (writer != null) {
                writer.writingState();
            }
            context.getResponseWriter().write("~com.sun.faces.saveStateFieldMarker~");
            LOGGER.fine(() -> "End writing marker for viewId " + context.getViewRoot().getViewId());
        }
    }

    public String getActionURL(FacesContext context, String viewId) {
        String result = this.getActionURLWithoutViewProtection(context, viewId);
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        Set urlPatterns = viewHandler.getProtectedViewsUnmodifiable();
        if (urlPatterns.contains(viewId)) {
            StringBuilder builder = new StringBuilder(result);
            if (result.contains("?")) {
                builder.append("&");
            } else {
                builder.append("?");
            }
            String tokenValue = RenderKitUtils.getResponseStateManager(context, viewHandler.calculateRenderKitId(context)).getCryptographicallyStrongTokenFromSession(context);
            builder.append("jakarta.faces.Token").append("=").append(tokenValue);
            result = builder.toString();
        }
        return result;
    }

    public String getResourceURL(FacesContext context, String path) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(path, "path");
        if (path.charAt(0) == '/') {
            return context.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    public String getWebsocketURL(FacesContext context, String channel) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(channel, "channel");
        ExternalContext externalContext = context.getExternalContext();
        return externalContext.encodeWebsocketURL(externalContext.getRequestContextPath() + "/jakarta.faces.push/" + channel);
    }

    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        Map<String, List<String>> params = includeViewParams ? this.getFullParameterList(context, viewId, parameters) : parameters;
        ExternalContext ectx = context.getExternalContext();
        return ectx.encodeActionURL(ectx.encodeBookmarkableURL(Util.getViewHandler(context).getActionURL(context, viewId), params));
    }

    public void addProtectedView(String urlPattern) {
        this.protectedViews.add(urlPattern);
    }

    public Set<String> getProtectedViewsUnmodifiable() {
        return Collections.unmodifiableSet(this.protectedViews);
    }

    public boolean removeProtectedView(String urlPattern) {
        return this.protectedViews.remove(urlPattern);
    }

    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        String responseEncoding;
        String encodingFromContext = (String)context.getAttributes().get("facelets.Encoding");
        if (encodingFromContext == null) {
            encodingFromContext = (String)context.getViewRoot().getAttributes().get("facelets.Encoding");
        }
        if (encodingFromContext == null) {
            try {
                responseEncoding = context.getExternalContext().getResponseCharacterEncoding();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e, () -> MessageFormat.format("Unable to obtain response character encoding from ExternalContext {0}.  Using UTF-8.", context.getExternalContext()));
                responseEncoding = "UTF-8";
            }
        } else {
            responseEncoding = encodingFromContext;
        }
        if (parameters != null) {
            HashMap<String, List<String>> decodedParameters = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                String string = entry.getKey();
                List<String> list = entry.getValue();
                ArrayList<String> values = new ArrayList<String>();
                for (String value : list) {
                    try {
                        value = URLDecoder.decode(value, responseEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Unable to decode");
                    }
                    values.add(value);
                }
                decodedParameters.put(string, values);
            }
            parameters = decodedParameters;
        }
        Map<String, List<String>> params = includeViewParams ? this.getFullParameterList(context, viewId, parameters) : parameters;
        ExternalContext ectx = context.getExternalContext();
        return ectx.encodeActionURL(ectx.encodeRedirectURL(Util.getViewHandler(context).getActionURL(context, viewId), params));
    }

    public ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context, String viewId) {
        return this.vdlFactory.getViewDeclarationLanguage(viewId);
    }

    public Stream<String> getViews(FacesContext context, String path, ViewVisitOption ... options) {
        return this.vdlFactory.getAllViewDeclarationLanguages().stream().flatMap(vdl -> vdl.getViews(context, path, options));
    }

    public Stream<String> getViews(FacesContext context, String path, int maxDepth, ViewVisitOption ... options) {
        return this.vdlFactory.getAllViewDeclarationLanguages().stream().flatMap(vdl -> vdl.getViews(context, path, maxDepth, options));
    }

    public String deriveViewId(FacesContext context, String requestViewId) {
        return this.derivePhysicalViewId(context, requestViewId, true);
    }

    public String deriveLogicalViewId(FacesContext context, String requestViewId) {
        return this.derivePhysicalViewId(context, requestViewId, false);
    }

    protected String derivePhysicalViewId(FacesContext ctx, String requestViewId, boolean checkPhysical) {
        if (requestViewId == null) {
            return null;
        }
        HttpServletMapping mapping = Util.getFacesMapping(ctx);
        String physicalViewId = mapping.getMappingMatch() == MappingMatch.EXACT || mapping.getMappingMatch() == MappingMatch.EXTENSION ? this.convertViewId(ctx, requestViewId) : this.normalizeRequestURI(requestViewId, mapping.getPattern().replace("/*", ""));
        if (checkPhysical && !this.getViewDeclarationLanguage(ctx, physicalViewId).viewExists(ctx, physicalViewId)) {
            return null;
        }
        return physicalViewId;
    }

    protected String normalizeRequestURI(String viewId, String mapping) {
        boolean logged = false;
        while (viewId.startsWith(mapping)) {
            if (!logged && LOGGER.isLoggable(Level.WARNING)) {
                logged = true;
                LOGGER.log(Level.WARNING, "faces.viewhandler.requestpath.recursion", new Object[]{viewId, mapping});
            }
            viewId = viewId.substring(mapping.length());
        }
        return viewId;
    }

    protected String convertViewId(FacesContext context, String viewId) {
        int extIdx = viewId.lastIndexOf(46);
        int length = viewId.length();
        StringBuilder buffer = new StringBuilder(length);
        for (String ext : this.configuredExtensions) {
            if (viewId.endsWith(ext)) {
                return viewId;
            }
            this.appendOrReplaceExtension(viewId, ext, length, extIdx, buffer);
            String convertedViewId = buffer.toString();
            ViewDeclarationLanguage vdl = this.getViewDeclarationLanguage(context, convertedViewId);
            if (!vdl.viewExists(context, convertedViewId)) continue;
            return convertedViewId;
        }
        return viewId;
    }

    protected Map<String, List<String>> getFullParameterList(FacesContext ctx, String viewId, Map<String, List<String>> existingParameters) {
        LinkedHashMap<Object, Object> copy = existingParameters == null || existingParameters.isEmpty() ? new LinkedHashMap(4) : new LinkedHashMap<String, List<String>>(existingParameters);
        this.addViewParameters(ctx, viewId, copy);
        return copy;
    }

    protected void addViewParameters(FacesContext ctx, String viewId, Map<String, List<String>> existingParameters) {
        UIViewRoot currentRoot = ctx.getViewRoot();
        String currentViewId = currentRoot.getViewId();
        Collection<Object> toViewParams = Collections.emptyList();
        boolean currentIsSameAsNew = false;
        Collection currentViewParams = ViewMetadata.getViewParameters((UIViewRoot)currentRoot);
        if (currentViewId.equals(viewId)) {
            currentIsSameAsNew = true;
            toViewParams = currentViewParams;
        } else {
            ViewMetadata viewMetadata = this.getViewDeclarationLanguage(ctx, viewId).getViewMetadata(ctx, viewId);
            if (viewMetadata != null) {
                UIViewRoot uIViewRoot = viewMetadata.createMetadataView(ctx);
                toViewParams = ViewMetadata.getViewParameters((UIViewRoot)uIViewRoot);
            }
        }
        if (toViewParams.isEmpty()) {
            return;
        }
        for (UIViewParameter uIViewParameter : toViewParams) {
            String value = null;
            if (existingParameters.containsKey(uIViewParameter.getName())) continue;
            if (MultiViewHandler.paramHasValueExpression(uIViewParameter)) {
                value = uIViewParameter.getStringValueFromModel(ctx);
            }
            if (value == null) {
                value = currentIsSameAsNew ? uIViewParameter.getStringValue(ctx) : MultiViewHandler.getStringValueToTransfer(ctx, uIViewParameter, currentViewParams);
            }
            if (value == null) continue;
            List<String> existing = existingParameters.get(uIViewParameter.getName());
            if (existing == null) {
                existing = new ArrayList<String>(4);
                existingParameters.put(uIViewParameter.getName(), existing);
            }
            existing.add(value);
        }
    }

    protected Locale findMatch(FacesContext context, Locale pref) {
        Locale defaultLocale;
        Locale result = null;
        Iterator it = context.getApplication().getSupportedLocales();
        while (it.hasNext()) {
            Locale supportedLocale = (Locale)it.next();
            if (pref.equals(supportedLocale)) {
                result = supportedLocale;
                break;
            }
            if (!pref.getLanguage().equals(supportedLocale.getLanguage()) || supportedLocale.getCountry().length() != 0) continue;
            result = supportedLocale;
        }
        if (result == null && (defaultLocale = context.getApplication().getDefaultLocale()) != null) {
            if (pref.equals(defaultLocale)) {
                result = defaultLocale;
            } else if (pref.getLanguage().equals(defaultLocale.getLanguage()) && defaultLocale.getCountry().length() == 0) {
                result = defaultLocale;
            }
        }
        return result;
    }

    protected void send404Error(FacesContext context) {
        try {
            context.responseComplete();
            context.getExternalContext().responseSendError(404, "");
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    private String getActionURLWithoutViewProtection(FacesContext context, String viewId) {
        Util.notNull("context", context);
        Util.notNull("viewId", viewId);
        if (viewId.length() == 0 || viewId.charAt(0) != '/') {
            LOGGER.log(Level.SEVERE, "faces.illegal_view_id_error", viewId);
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", viewId));
        }
        String contextPath = context.getExternalContext().getRequestContextPath();
        HttpServletMapping mapping = Util.getFacesMapping(context);
        if (mapping.getMappingMatch() == MappingMatch.EXACT) {
            if (viewId.contains(".")) {
                for (String extension : this.configuredExtensions) {
                    String exactViewId;
                    if (!viewId.endsWith(extension) || !Util.isViewIdExactMappedToFacesServlet(exactViewId = viewId.substring(0, viewId.lastIndexOf(extension)))) continue;
                    return contextPath + exactViewId;
                }
            } else if (Util.isViewIdExactMappedToFacesServlet(viewId)) {
                return contextPath + viewId;
            }
            if ((mapping = Util.getFirstWildCardMappingToFacesServlet(context.getExternalContext())) == null) {
                throw new IllegalStateException("No suitable mapping for FacesServlet found. To serve views that are not exact mapped FacesServlet should have at least one prefix or suffix mapping.");
            }
        }
        if (mapping.getMappingMatch() == MappingMatch.PATH) {
            return contextPath + mapping.getPattern().replace("/*", viewId);
        }
        if (!viewId.contains(".")) {
            return contextPath + mapping.getPattern().replace("*", viewId);
        }
        String mappingExtension = mapping.getPattern().replace("*", "");
        if (viewId.endsWith(mappingExtension)) {
            return contextPath + viewId;
        }
        return contextPath + viewId.substring(0, viewId.lastIndexOf(46)) + mappingExtension;
    }

    private static boolean paramHasValueExpression(UIViewParameter param) {
        return param.getValueExpression("value") != null;
    }

    private static String getStringValueToTransfer(FacesContext context, UIViewParameter param, Collection<UIViewParameter> viewParams) {
        if (viewParams != null && !viewParams.isEmpty()) {
            for (UIViewParameter candidate : viewParams) {
                if (candidate.getName() == null || param.getName() == null || !candidate.getName().equals(param.getName())) continue;
                return candidate.getStringValue(context);
            }
        }
        return param.getStringValue(context);
    }

    private void appendOrReplaceExtension(String viewId, String extension, int length, int extensionIndex, StringBuilder buffer) {
        buffer.setLength(0);
        buffer.append(viewId);
        if (extensionIndex != -1) {
            buffer.replace(extensionIndex, length, extension);
        } else {
            buffer.append(extension);
        }
    }
}

