/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public abstract class AbstractModulesServiceConfigurator<T>
extends SimpleServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<List<Module>>,
Function<List<Module>, T> {
    private final Attribute attribute;
    private final SupplierDependency<ModuleLoader> loader = new ServiceSupplierDependency(Services.JBOSS_SERVICE_MODULE_LOADER);
    private final Function<ModelNode, List<ModelNode>> toList;
    private volatile List<ModelNode> identifiers = Collections.emptyList();

    AbstractModulesServiceConfigurator(ServiceName name, Attribute attribute, Function<ModelNode, List<ModelNode>> toList) {
        super(name);
        this.attribute = attribute;
        this.toList = toList;
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.identifiers = this.toList.apply(this.attribute.resolveModelAttribute((ExpressionResolver)context, model));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer modules = this.loader.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(modules, (Function)this, (Supplier)this);
        return builder.setInstance((Service)service);
    }

    @Override
    public List<Module> get() {
        List<ModelNode> identifiers = this.identifiers;
        ArrayList<Module> modules = !identifiers.isEmpty() ? new ArrayList<Module>(identifiers.size()) : Collections.emptyList();
        for (ModelNode identifier : identifiers) {
            try {
                modules.add(((ModuleLoader)this.loader.get()).loadModule(identifier.asString()));
            }
            catch (ModuleLoadException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return modules;
    }
}

