/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan.scheduler;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.infinispan.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.distribution.Locality;
import org.wildfly.clustering.infinispan.listener.ListenerRegistrar;
import org.wildfly.clustering.infinispan.listener.ListenerRegistration;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class SchedulerTopologyChangeListener<I, K extends Key<I>, V>
implements ListenerRegistrar {
    private final Cache<K, V> cache;
    private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory(SchedulerTopologyChangeListener.class));
    private final AtomicReference<Future<?>> scheduleTaskFuture = new AtomicReference();
    private final Consumer<Locality> cancelTask;
    private final BiConsumer<Locality, Locality> scheduleTask;
    private final KeyPartitioner partitioner;
    private final BlockingManager blocking;

    public SchedulerTopologyChangeListener(Cache<K, V> cache, CacheEntryScheduler<I, ?> scheduler, BiConsumer<Locality, Locality> scheduleTask) {
        this(cache, scheduler::cancel, scheduleTask);
    }

    public SchedulerTopologyChangeListener(Cache<K, V> cache, Consumer<Locality> cancelTask, BiConsumer<Locality, Locality> scheduleTask) {
        this.cache = cache;
        this.cancelTask = cancelTask;
        this.scheduleTask = scheduleTask;
        this.blocking = (BlockingManager)this.cache.getCacheManager().getGlobalComponentRegistry().getComponent(BlockingManager.class);
        this.partitioner = (KeyPartitioner)this.cache.getAdvancedCache().getComponentRegistry().getLocalComponent(KeyPartitioner.class);
    }

    public ListenerRegistration register() {
        this.cache.addListener((Object)this);
        return () -> {
            this.cache.removeListener((Object)this);
            WildFlySecurityManager.doUnchecked((Object)this.executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
            try {
                this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<K, V> event) {
        Set newSegments;
        Cache cache = event.getCache();
        Address address = cache.getCacheManager().getAddress();
        ConsistentHash oldHash = event.getWriteConsistentHashAtStart();
        Set oldSegments = oldHash.getMembers().contains(address) ? oldHash.getPrimarySegmentsForOwner(address) : Collections.emptySet();
        ConsistentHash newHash = event.getWriteConsistentHashAtEnd();
        Set set = newSegments = newHash.getMembers().contains(address) ? newHash.getPrimarySegmentsForOwner(address) : Collections.emptySet();
        if (event.isPre()) {
            if (!newSegments.containsAll(oldSegments)) {
                Future future = this.scheduleTaskFuture.getAndSet(null);
                if (future != null) {
                    future.cancel(true);
                }
                return this.blocking.runBlocking(() -> this.cancelTask.accept((Locality)new ConsistentHashLocality(this.partitioner, newHash, address)), (Object)this.getClass().getName());
            }
        } else if (!oldSegments.containsAll(newSegments)) {
            ConsistentHashLocality oldLocality = new ConsistentHashLocality(this.partitioner, oldHash, address);
            ConsistentHashLocality newLocality = new ConsistentHashLocality(this.partitioner, newHash, address);
            try {
                Future<?> future = this.scheduleTaskFuture.getAndSet(this.executor.submit(() -> this.lambda$topologyChanged$2((Locality)oldLocality, (Locality)newLocality)));
                if (future != null) {
                    future.cancel(true);
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return CompletableFutures.completedNull();
    }

    private /* synthetic */ void lambda$topologyChanged$2(Locality oldLocality, Locality newLocality) {
        this.scheduleTask.accept(oldLocality, newLocality);
    }
}

