/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private SecureRandom random;
    private boolean withIntegrityPacket;
    private int encAlgorithm;

    public BcPGPDataEncryptorBuilder(int n) {
        this.encAlgorithm = n;
        if (n == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    @Override
    public BcPGPDataEncryptorBuilder setWithIntegrityPacket(boolean bl) {
        this.withIntegrityPacket = bl;
        return this;
    }

    public BcPGPDataEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    @Override
    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    @Override
    public PGPDataEncryptor build(byte[] byArray) throws PGPException {
        return new MyPGPDataEncryptor(byArray);
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final BufferedBlockCipher c;

        MyPGPDataEncryptor(byte[] byArray) throws PGPException {
            BlockCipher blockCipher = BcImplProvider.createBlockCipher(BcPGPDataEncryptorBuilder.this.encAlgorithm);
            try {
                this.c = BcUtil.createStreamCipher(true, blockCipher, BcPGPDataEncryptorBuilder.this.withIntegrityPacket, byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new PGPException("invalid parameters: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }

        @Override
        public OutputStream getOutputStream(OutputStream outputStream) {
            return new CipherOutputStream(outputStream, this.c);
        }

        @Override
        public PGPDigestCalculator getIntegrityCalculator() {
            if (BcPGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        @Override
        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

