/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;

public class SqmTreatedCrossJoin<T, S extends T>
extends SqmCrossJoin<S>
implements SqmTreatedPath<T, S> {
    private final SqmCrossJoin<T> wrappedPath;
    private final EntityDomainType<S> treatTarget;

    public SqmTreatedCrossJoin(SqmCrossJoin<T> wrappedPath, EntityDomainType<S> treatTarget, String alias) {
        super(wrappedPath.getNavigablePath().treatAs(treatTarget.getHibernateEntityName(), alias), (EntityDomainType)wrappedPath.getReferencedPathSource().getSqmPathType(), alias, wrappedPath.getRoot());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    @Override
    public SqmTreatedCrossJoin<T, S> copy(SqmCopyContext context) {
        SqmTreatedCrossJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedCrossJoin<T, S> path = context.registerCopy(this, new SqmTreatedCrossJoin<T, S>(this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public EntityDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType<S> getModel() {
        return this.getTreatTarget();
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public SqmPathSource<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType<S> getReferencedPathSource() {
        return this.wrappedPath.getReferencedPathSource();
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getName());
        sb.append(')');
    }
}

