/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.distributable;

import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.Contextual;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.distributable.DistributableCache;
import org.jboss.as.ejb3.cache.distributable.RemoveListenerAdapter;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.BeanManagerFactory;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class DistributableCacheFactoryServiceConfigurator<K, V extends Identifiable<K> & Contextual<Batch>>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
CacheFactory<K, V> {
    private final CapabilityServiceConfigurator configurator;
    private final SupplierDependency<BeanManagerFactory<K, V, Batch>> factory;
    private volatile SupplierDependency<TransactionSynchronizationRegistry> tsr;

    public DistributableCacheFactoryServiceConfigurator(ServiceName name, CapabilityServiceConfigurator configurator) {
        super(name);
        this.configurator = configurator;
        this.factory = new ServiceSupplierDependency((ServiceNameProvider)configurator);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.configurator.configure(support);
        this.tsr = new ServiceSupplierDependency(support.getCapabilityServiceName("org.wildfly.transactions.transaction-synchronization-registry"));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        this.configurator.build(target).install();
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer factory = new CompositeDependency(new Dependency[]{this.factory, this.tsr}).register(builder).provides(new ServiceName[]{name});
        Service service = Service.newInstance((Consumer)factory, (Object)this);
        return builder.setInstance(service);
    }

    @Override
    public Cache<K, V> createCache(Supplier<K> identifierFactory, StatefulObjectFactory<V> factory, PassivationListener<V> passivationListener) {
        BeanManager manager = ((BeanManagerFactory)this.factory.get()).createBeanManager(identifierFactory, passivationListener, new RemoveListenerAdapter(factory));
        return new DistributableCache(manager, factory, (TransactionSynchronizationRegistry)this.tsr.get());
    }
}

