/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.ifelse.Operand;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;

public class ModelNodePathOperand
implements Operand {
    private final String[] path;

    public ModelNodePathOperand(String pathStr) throws CommandFormatException {
        Assert.checkNotNullParam("pathStr", pathStr);
        this.path = pathStr.split("\\.");
        if (this.path.length == 0) {
            throw new CommandFormatException("The path in the if condition is empty: '" + pathStr + "'");
        }
    }

    @Override
    public Object resolveValue(CommandContext ctx, ModelNode response) throws CommandLineException {
        ModelNode targetValue = response;
        for (String name : this.path) {
            if (!targetValue.has(name)) {
                return null;
            }
            targetValue = targetValue.get(name);
        }
        return targetValue == null ? null : targetValue;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.path[0]);
        for (int i = 1; i < this.path.length; ++i) {
            buf.append('.').append(this.path[i]);
        }
        return buf.toString();
    }
}

